/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.zone.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UpgradePolicy {
    private final List<List<ZoneId>> zones;

    private UpgradePolicy(List<List<ZoneId>> zones) {
        this.zones = zones;
    }

    public List<List<ZoneId>> asList() {
        return Collections.unmodifiableList(this.zones);
    }

    private UpgradePolicy with(ZoneId ... zone) {
        ArrayList<List<ZoneId>> zones = new ArrayList<List<ZoneId>>(this.zones);
        zones.add(Arrays.asList(zone));
        return new UpgradePolicy(zones);
    }

    public UpgradePolicy upgrade(ZoneId zone) {
        return this.with(zone);
    }

    public UpgradePolicy upgradeInParallel(ZoneId ... zone) {
        return this.with(zone);
    }

    public static UpgradePolicy create() {
        return new UpgradePolicy(Collections.emptyList());
    }
}

