/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import java.util.Objects;

public class ZoneId {
    private final Environment environment;
    private final RegionName region;

    private ZoneId(Environment environment, RegionName region) {
        this.environment = Objects.requireNonNull(environment, "environment must be non-null");
        this.region = Objects.requireNonNull(region, "region must be non-null");
    }

    public static ZoneId from(Environment environment, RegionName region) {
        return new ZoneId(environment, region);
    }

    public static ZoneId from(String environment, String region) {
        return ZoneId.from(Environment.from(environment), RegionName.from(region));
    }

    public static ZoneId from(String value) {
        String[] parts = value.split("\\.");
        switch (parts.length) {
            case 2: {
                return ZoneId.from(parts[0], parts[1]);
            }
            case 4: {
                return ZoneId.from(parts[2], parts[3]);
            }
        }
        throw new IllegalArgumentException("Cannot deserialize zone id '" + value + "'");
    }

    public static ZoneId defaultId() {
        return new ZoneId(Environment.defaultEnvironment(), RegionName.defaultName());
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public String value() {
        return this.environment + "." + this.region;
    }

    public String toString() {
        return this.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoneId zoneId = (ZoneId)o;
        return this.environment == zoneId.environment && Objects.equals(this.region, zoneId.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }
}

