/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.zone.ZoneApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UpgradePolicy {
    private final List<List<ZoneApi>> zones;

    private UpgradePolicy(List<List<ZoneApi>> zones) {
        this.zones = zones;
    }

    public List<List<ZoneApi>> asList() {
        return List.copyOf(this.zones);
    }

    private UpgradePolicy with(ZoneApi ... zone) {
        ArrayList<List<ZoneApi>> zones = new ArrayList<List<ZoneApi>>(this.zones);
        zones.add(Arrays.asList(zone));
        return new UpgradePolicy(zones);
    }

    public UpgradePolicy upgrade(ZoneApi zone) {
        return this.with(zone);
    }

    public UpgradePolicy upgradeInParallel(ZoneApi ... zone) {
        return this.with(zone);
    }

    public static UpgradePolicy create() {
        return new UpgradePolicy(Collections.emptyList());
    }
}

