/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import java.util.Objects;
import java.util.Optional;

public class DockerImage {
    public static final DockerImage EMPTY = new DockerImage("", "", Optional.empty(), Optional.empty());
    private final String registry;
    private final String repository;
    private final Optional<String> tag;
    private final Optional<DockerImage> replacedBy;

    DockerImage(String registry, String repository, Optional<String> tag, Optional<DockerImage> replacedBy) {
        this.registry = Objects.requireNonNull(registry, "registry must be non-null");
        this.repository = Objects.requireNonNull(repository, "repository must be non-null");
        this.tag = Objects.requireNonNull(tag, "tag must be non-null");
        this.replacedBy = Objects.requireNonNull(replacedBy);
    }

    public String registry() {
        return this.registry;
    }

    public String repository() {
        return this.repository;
    }

    public String untagged() {
        return new DockerImage(this.registry, this.repository, Optional.empty(), this.replacedBy).asString();
    }

    public Optional<String> tag() {
        return this.tag;
    }

    public Version tagAsVersion() {
        return this.tag.map(Version::new).orElse(Version.emptyVersion);
    }

    public Optional<DockerImage> replacedBy() {
        return this.replacedBy;
    }

    public DockerImage withTag(Version version) {
        return new DockerImage(this.registry, this.repository, Optional.of(version.toFullString()), this.replacedBy);
    }

    public DockerImage withRegistry(String registry) {
        return new DockerImage(registry, this.repository, this.tag, this.replacedBy);
    }

    public DockerImage withReplacedBy(DockerImage image) {
        return new DockerImage(this.registry, this.repository, this.tag, Optional.of(image).filter(i -> !i.equals(EMPTY)));
    }

    public String asString() {
        if (this.equals(EMPTY)) {
            return "";
        }
        return this.registry + "/" + this.repository + this.tag.map(t -> ":" + t).orElse("");
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerImage that = (DockerImage)o;
        return this.registry.equals(that.registry) && this.repository.equals(that.repository) && this.tag.equals(that.tag) && this.replacedBy.equals(that.replacedBy);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.repository, this.tag, this.replacedBy);
    }

    public static DockerImage from(String registry, String repository) {
        return new DockerImage(registry, repository, Optional.empty(), Optional.empty());
    }

    public static DockerImage fromString(String s) {
        if (s.isEmpty()) {
            return EMPTY;
        }
        int firstPathSeparator = s.indexOf(47);
        if (firstPathSeparator < 0) {
            throw new IllegalArgumentException("Missing path separator in '" + s + "'");
        }
        String registry = s.substring(0, firstPathSeparator);
        String repository = s.substring(firstPathSeparator + 1);
        if (repository.isEmpty()) {
            throw new IllegalArgumentException("Repository must be non-empty in '" + s + "'");
        }
        int tagStart = repository.indexOf(58);
        if (tagStart < 0) {
            return new DockerImage(registry, repository, Optional.empty(), Optional.empty());
        }
        String tag = repository.substring(tagStart + 1);
        repository = repository.substring(0, tagStart);
        return new DockerImage(registry, repository, Optional.of(tag), Optional.empty());
    }
}

