/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.List;

public enum NodeType {
    tenant("Tenant node", new NodeType[0]),
    host("Tenant host", tenant),
    proxy("Proxy node", new NodeType[0]),
    proxyhost("Proxy host", proxy),
    config("Config server node", new NodeType[0]),
    confighost("Config server host", config),
    controller("Controller node", new NodeType[0]),
    controllerhost("Controller host", controller),
    devhost("Dev host", config, controller, tenant);

    private final String description;
    private final List<NodeType> childNodeTypes;

    private NodeType(String description, NodeType ... childNodeTypes) {
        this.childNodeTypes = List.of(childNodeTypes);
        this.description = description;
    }

    public boolean isHost() {
        return !this.childNodeTypes.isEmpty();
    }

    public boolean isConfigServerLike() {
        return this == config || this == controller;
    }

    public boolean isConfigServerHostLike() {
        return this == confighost || this == controllerhost;
    }

    public boolean isSharable() {
        return this == host;
    }

    public String description() {
        return this.description;
    }

    public NodeType childNodeType() {
        return this.childNodeTypes().get(0);
    }

    public List<NodeType> childNodeTypes() {
        if (!this.isHost()) {
            throw new IllegalStateException(this + " has no children");
        }
        return this.childNodeTypes;
    }

    public boolean canRun(NodeType type) {
        return this.childNodeTypes.contains((Object)type);
    }

    public NodeType hostType() {
        if (this.isHost()) {
            return this;
        }
        for (NodeType nodeType : NodeType.values()) {
            if (nodeType.childNodeTypes.size() != 1 || !nodeType.canRun(this)) continue;
            return nodeType;
        }
        throw new IllegalArgumentException("No host of " + this + " exists");
    }
}

