/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.List;

public enum NodeType {
    tenant("Tenant node", new NodeType[0]),
    host("Tenant docker host", tenant),
    proxy("Proxy node", new NodeType[0]),
    proxyhost("Proxy docker host", proxy),
    config("Config server", new NodeType[0]),
    confighost("Config docker host", config),
    controller("Controller", new NodeType[0]),
    controllerhost("Controller host", controller),
    devhost("Dev host", config, controller, tenant);

    private final List<NodeType> childNodeTypes;
    private final String description;

    private NodeType(String description, NodeType ... childNodeTypes) {
        this.childNodeTypes = List.of(childNodeTypes);
        this.description = description;
    }

    public boolean isHost() {
        return !this.childNodeTypes.isEmpty();
    }

    public String description() {
        return this.description;
    }

    public NodeType childNodeType() {
        return this.childNodeTypes().get(0);
    }

    public List<NodeType> childNodeTypes() {
        if (!this.isHost()) {
            throw new IllegalStateException(this + " has no children");
        }
        return this.childNodeTypes;
    }

    public boolean canRun(NodeType type) {
        return this.childNodeTypes.contains((Object)type);
    }
}

