/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import java.util.Objects;
import java.util.Optional;

public class ClusterMembership {
    private ClusterSpec cluster;
    private int index;
    private boolean retired;
    private String stringValue;

    protected ClusterMembership() {
    }

    private ClusterMembership(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo) {
        String[] components = stringValue.split("/");
        if (components.length < 4) {
            throw new RuntimeException("Could not parse '" + stringValue + "' to a cluster membership. Expected 'clusterType/clusterId/groupId/index[/retired][/exclusive][/stateful][/combinedId]'");
        }
        boolean exclusive = false;
        boolean stateful = false;
        Optional<String> combinedId = Optional.empty();
        if (components.length > 4) {
            block10: for (int i = 4; i < components.length; ++i) {
                String component;
                switch (component = components[i]) {
                    case "exclusive": {
                        exclusive = true;
                        continue block10;
                    }
                    case "retired": {
                        this.retired = true;
                        continue block10;
                    }
                    case "stateful": {
                        stateful = true;
                        continue block10;
                    }
                    default: {
                        combinedId = Optional.of(component);
                    }
                }
            }
        }
        this.cluster = ClusterSpec.specification(ClusterSpec.Type.valueOf(components[0]), ClusterSpec.Id.from(components[1])).group(ClusterSpec.Group.from(Integer.parseInt(components[2]))).vespaVersion(vespaVersion).exclusive(exclusive).combinedId(combinedId.map(ClusterSpec.Id::from)).dockerImageRepository(dockerImageRepo).stateful(stateful).build();
        this.index = Integer.parseInt(components[3]);
        this.stringValue = this.toStringValue();
    }

    private ClusterMembership(ClusterSpec cluster, int index, boolean retired) {
        this.cluster = cluster;
        this.index = index;
        this.retired = retired;
        this.stringValue = this.toStringValue();
    }

    protected String toStringValue() {
        return this.cluster.type().name() + "/" + this.cluster.id().value() + (String)(this.cluster.group().isPresent() ? "/" + this.cluster.group().get().index() : "") + "/" + this.index + (this.cluster.isExclusive() ? "/exclusive" : "") + (this.retired ? "/retired" : "") + (this.cluster.isStateful() ? "/stateful" : "") + (String)(this.cluster.combinedId().isPresent() ? "/" + this.cluster.combinedId().get().value() : "");
    }

    public ClusterSpec cluster() {
        return this.cluster;
    }

    public int index() {
        return this.index;
    }

    public boolean retired() {
        return this.retired;
    }

    public ClusterMembership retire() {
        return new ClusterMembership(this.cluster, this.index, true);
    }

    public ClusterMembership unretire() {
        return new ClusterMembership(this.cluster, this.index, false);
    }

    public ClusterMembership with(ClusterSpec newCluster) {
        return new ClusterMembership(newCluster, this.index, this.retired);
    }

    public String stringValue() {
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMembership that = (ClusterMembership)o;
        return this.index == that.index && this.retired == that.retired && this.cluster.equals(that.cluster) && this.stringValue.equals(that.stringValue);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.index, this.retired, this.stringValue);
    }

    public String toString() {
        return this.stringValue();
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo) {
        return new ClusterMembership(stringValue, vespaVersion, dockerImageRepo);
    }

    public static ClusterMembership from(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, false);
    }

    public static ClusterMembership retiredFrom(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, true);
    }
}

