/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provisioning;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class NodeRepositoryConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "4a4a9b2713bb40325189487447f17e48";
    public static final String CONFIG_DEF_NAME = "node-repository";
    public static final String CONFIG_DEF_NAMESPACE = "config.provisioning";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=config.provisioning", "containerImage string default=\"registry.example.com:9999/myorg/vespa\"", "containerImageReplacement string default=\"\"", "useCuratorClientCache bool default=false", "nodeCacheSize long default=2000"};
    private final StringNode containerImage;
    private final StringNode containerImageReplacement;
    private final BooleanNode useCuratorClientCache;
    private final LongNode nodeCacheSize;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public NodeRepositoryConfig(Builder builder) {
        this(builder, true);
    }

    private NodeRepositoryConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for node-repository must be initialized: " + builder.__uninitialized);
        }
        this.containerImage = builder.containerImage == null ? new StringNode("registry.example.com:9999/myorg/vespa") : new StringNode(builder.containerImage);
        this.containerImageReplacement = builder.containerImageReplacement == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.containerImageReplacement);
        this.useCuratorClientCache = builder.useCuratorClientCache == null ? new BooleanNode(false) : new BooleanNode(builder.useCuratorClientCache.booleanValue());
        this.nodeCacheSize = builder.nodeCacheSize == null ? new LongNode(2000L) : new LongNode(builder.nodeCacheSize.longValue());
    }

    public String containerImage() {
        return this.containerImage.value();
    }

    public String containerImageReplacement() {
        return this.containerImageReplacement.value();
    }

    public boolean useCuratorClientCache() {
        return this.useCuratorClientCache.value();
    }

    public long nodeCacheSize() {
        return this.nodeCacheSize.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(NodeRepositoryConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String containerImage = null;
        private String containerImageReplacement = null;
        private Boolean useCuratorClientCache = null;
        private Long nodeCacheSize = null;

        public Builder() {
        }

        public Builder(NodeRepositoryConfig config) {
            this.containerImage(config.containerImage());
            this.containerImageReplacement(config.containerImageReplacement());
            this.useCuratorClientCache(config.useCuratorClientCache());
            this.nodeCacheSize(config.nodeCacheSize());
        }

        private Builder override(Builder __superior) {
            if (__superior.containerImage != null) {
                this.containerImage(__superior.containerImage);
            }
            if (__superior.containerImageReplacement != null) {
                this.containerImageReplacement(__superior.containerImageReplacement);
            }
            if (__superior.useCuratorClientCache != null) {
                this.useCuratorClientCache(__superior.useCuratorClientCache);
            }
            if (__superior.nodeCacheSize != null) {
                this.nodeCacheSize(__superior.nodeCacheSize);
            }
            return this;
        }

        public Builder containerImage(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.containerImage = __value;
            return this;
        }

        public Builder containerImageReplacement(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.containerImageReplacement = __value;
            return this;
        }

        public Builder useCuratorClientCache(boolean __value) {
            this.useCuratorClientCache = __value;
            return this;
        }

        private Builder useCuratorClientCache(String __value) {
            return this.useCuratorClientCache(Boolean.valueOf(__value));
        }

        public Builder nodeCacheSize(long __value) {
            this.nodeCacheSize = __value;
            return this;
        }

        private Builder nodeCacheSize(String __value) {
            return this.nodeCacheSize(Long.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return NodeRepositoryConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return NodeRepositoryConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return NodeRepositoryConfig.CONFIG_DEF_NAMESPACE;
        }

        public NodeRepositoryConfig build() {
            return new NodeRepositoryConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

