/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

public enum Environment {
    prod,
    staging,
    test,
    dev,
    perf;


    public boolean isManuallyDeployed() {
        return this == dev || this == perf;
    }

    public boolean isTest() {
        return this == test || this == staging;
    }

    public boolean isProduction() {
        return this == prod;
    }

    public boolean isMultiRegion() {
        return this == prod || this == dev;
    }

    public static Environment defaultEnvironment() {
        return prod;
    }

    public static Environment from(String value) {
        switch (value) {
            case "prod": {
                return prod;
            }
            case "staging": {
                return staging;
            }
            case "test": {
                return test;
            }
            case "dev": {
                return dev;
            }
            case "perf": {
                return perf;
            }
        }
        throw new IllegalStateException("'" + value + "' is not a valid environment identifier");
    }

    public String value() {
        switch (this) {
            case prod: {
                return "prod";
            }
            case staging: {
                return "staging";
            }
            case test: {
                return "test";
            }
            case dev: {
                return "dev";
            }
            case perf: {
                return "perf";
            }
        }
        throw new IllegalStateException();
    }
}

