/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import java.util.Objects;
import java.util.Optional;

public class Zone {
    private final CloudName cloudName;
    private final SystemName systemName;
    private final Environment environment;
    private final RegionName region;
    private final FlavorDefaults flavorDefaults;
    private final Optional<NodeFlavors> nodeFlavors;

    @Inject
    public Zone(ConfigserverConfig configserverConfig, NodeFlavors nodeFlavors) {
        this(CloudName.from(configserverConfig.cloud()), SystemName.from(configserverConfig.system()), Environment.from(configserverConfig.environment()), RegionName.from(configserverConfig.region()), new FlavorDefaults(configserverConfig), nodeFlavors);
    }

    public Zone(Environment environment, RegionName region) {
        this(SystemName.defaultSystem(), environment, region);
    }

    public Zone(SystemName systemName, Environment environment, RegionName region) {
        this(CloudName.defaultName(), systemName, environment, region);
    }

    public Zone(CloudName cloudName, SystemName systemName, Environment environment, RegionName region) {
        this(cloudName, systemName, environment, region, null);
    }

    public Zone(CloudName cloudName, SystemName systemName, Environment environment, RegionName region, NodeFlavors nodeFlavors) {
        this(cloudName, systemName, environment, region, new FlavorDefaults("default"), nodeFlavors);
    }

    private Zone(CloudName cloudName, SystemName systemName, Environment environment, RegionName region, FlavorDefaults flavorDefaults, NodeFlavors nodeFlavors) {
        this.cloudName = cloudName;
        this.systemName = systemName;
        this.environment = environment;
        this.region = region;
        this.flavorDefaults = flavorDefaults;
        this.nodeFlavors = Optional.ofNullable(nodeFlavors);
    }

    public CloudName cloud() {
        return this.cloudName;
    }

    public SystemName system() {
        return this.systemName;
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public String defaultFlavor(ClusterSpec.Type clusterType) {
        return this.flavorDefaults.flavor(clusterType);
    }

    public Optional<NodeFlavors> nodeFlavors() {
        return this.nodeFlavors;
    }

    public static Zone defaultZone() {
        return new Zone(CloudName.defaultName(), SystemName.defaultSystem(), Environment.defaultEnvironment(), RegionName.defaultName());
    }

    public String toString() {
        return "zone " + this.environment + "." + this.region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)o;
        return this.environment == zone.environment && Objects.equals(this.region, zone.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }

    private static class FlavorDefaults {
        private final String defaultFlavor;
        private final Optional<String> adminFlavor;
        private final Optional<String> containerFlavor;
        private final Optional<String> contentFlavor;

        public FlavorDefaults(String defaultFlavor) {
            this(defaultFlavor, Optional.empty(), Optional.empty(), Optional.empty());
        }

        public FlavorDefaults(String defaultFlavor, Optional<String> adminFlavor, Optional<String> containerFlavor, Optional<String> contentFlavor) {
            this.defaultFlavor = defaultFlavor;
            this.adminFlavor = adminFlavor;
            this.containerFlavor = containerFlavor;
            this.contentFlavor = contentFlavor;
        }

        public FlavorDefaults(ConfigserverConfig config) {
            this(config.defaultFlavor(), FlavorDefaults.emptyIfDefault(config.defaultAdminFlavor()), FlavorDefaults.emptyIfDefault(config.defaultContainerFlavor()), FlavorDefaults.emptyIfDefault(config.defaultContentFlavor()));
        }

        private static Optional<String> emptyIfDefault(String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return Optional.empty();
            }
            if (value.equals("default")) {
                return Optional.empty();
            }
            return Optional.of(value);
        }

        public String flavor(ClusterSpec.Type clusterType) {
            switch (clusterType) {
                case admin: {
                    return this.adminFlavor.orElse(this.defaultFlavor);
                }
                case container: {
                    return this.containerFlavor.orElse(this.defaultFlavor);
                }
                case content: {
                    return this.contentFlavor.orElse(this.defaultFlavor);
                }
            }
            return this.defaultFlavor;
        }
    }
}

