/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import java.util.Optional;

public class ClusterMembership {
    private ClusterSpec cluster;
    private int index;
    private boolean retired;
    private String stringValue;

    protected ClusterMembership() {
    }

    private ClusterMembership(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo) {
        String[] components = stringValue.split("/");
        if (components.length < 4) {
            throw new RuntimeException("Could not parse '" + stringValue + "' to a cluster membership. Expected 'clusterType/clusterId/groupId/index[/retired][/exclusive][/combinedId]'");
        }
        boolean exclusive = false;
        Optional<String> combinedId = Optional.empty();
        if (components.length > 4) {
            block8: for (int i = 4; i < components.length; ++i) {
                String component;
                switch (component = components[i]) {
                    case "exclusive": {
                        exclusive = true;
                        continue block8;
                    }
                    case "retired": {
                        this.retired = true;
                        continue block8;
                    }
                    default: {
                        combinedId = Optional.of(component);
                    }
                }
            }
        }
        this.cluster = ClusterSpec.specification(ClusterSpec.Type.valueOf(components[0]), ClusterSpec.Id.from(components[1])).group(ClusterSpec.Group.from(Integer.parseInt(components[2]))).vespaVersion(vespaVersion).exclusive(exclusive).combinedId(combinedId.map(ClusterSpec.Id::from)).dockerImageRepository(dockerImageRepo).build();
        this.index = Integer.parseInt(components[3]);
        this.stringValue = this.toStringValue();
    }

    private ClusterMembership(ClusterSpec cluster, int index, boolean retired) {
        this.cluster = cluster;
        this.index = index;
        this.retired = retired;
        this.stringValue = this.toStringValue();
    }

    protected String toStringValue() {
        return this.cluster.type().name() + "/" + this.cluster.id().value() + (String)(this.cluster.group().isPresent() ? "/" + this.cluster.group().get().index() : "") + "/" + this.index + (this.cluster.isExclusive() ? "/exclusive" : "") + (this.retired ? "/retired" : "") + (String)(this.cluster.combinedId().isPresent() ? "/" + this.cluster.combinedId().get().value() : "");
    }

    public ClusterSpec cluster() {
        return this.cluster;
    }

    public int index() {
        return this.index;
    }

    public boolean retired() {
        return this.retired;
    }

    public ClusterMembership retire() {
        return new ClusterMembership(this.cluster, this.index, true);
    }

    public ClusterMembership unretire() {
        return new ClusterMembership(this.cluster, this.index, false);
    }

    public ClusterMembership with(ClusterSpec newCluster) {
        return new ClusterMembership(newCluster, this.index, this.retired);
    }

    public String stringValue() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.stringValue().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClusterMembership)) {
            return false;
        }
        return ((ClusterMembership)other).stringValue().equals(this.stringValue());
    }

    public String toString() {
        return this.stringValue();
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion) {
        return new ClusterMembership(stringValue, vespaVersion, Optional.empty());
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo) {
        return new ClusterMembership(stringValue, vespaVersion, dockerImageRepo);
    }

    public static ClusterMembership from(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, false);
    }

    public static ClusterMembership retiredFrom(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, true);
    }
}

