/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.config.provision.NodeResources;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HostSpec
implements Comparable<HostSpec> {
    private final String hostname;
    private final List<String> aliases;
    private final NodeResources realResources;
    private final NodeResources advertisedResources;
    private final NodeResources requestedResources;
    private final Optional<ClusterMembership> membership;
    private final Optional<Version> version;
    private final Optional<DockerImage> dockerImageRepo;
    private final Optional<NetworkPorts> networkPorts;

    public HostSpec(String hostname, List<String> aliases, Optional<NetworkPorts> networkPorts) {
        this(hostname, aliases, NodeResources.unspecified(), NodeResources.unspecified(), NodeResources.unspecified(), Optional.empty(), Optional.empty(), networkPorts, Optional.empty());
    }

    public HostSpec(String hostname, NodeResources realResources, NodeResources advertisedResurces, NodeResources requestedResources, ClusterMembership membership, Optional<Version> version, Optional<NetworkPorts> networkPorts, Optional<DockerImage> dockerImageRepo) {
        this(hostname, List.of(), realResources, advertisedResurces, requestedResources, Optional.of(membership), version, networkPorts, dockerImageRepo);
    }

    private HostSpec(String hostname, List<String> aliases, NodeResources realResources, NodeResources advertisedResurces, NodeResources requestedResources, Optional<ClusterMembership> membership, Optional<Version> version, Optional<NetworkPorts> networkPorts, Optional<DockerImage> dockerImageRepo) {
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("Hostname must be specified");
        }
        this.hostname = hostname;
        this.aliases = List.copyOf(aliases);
        this.realResources = Objects.requireNonNull(realResources);
        this.advertisedResources = Objects.requireNonNull(advertisedResurces);
        this.requestedResources = Objects.requireNonNull(requestedResources, "RequestedResources cannot be null");
        this.membership = Objects.requireNonNull(membership);
        this.version = Objects.requireNonNull(version, "Version cannot be null but can be empty");
        this.networkPorts = Objects.requireNonNull(networkPorts, "Network ports cannot be null but can be empty");
        this.dockerImageRepo = Objects.requireNonNull(dockerImageRepo, "Docker image repo cannot be null but can be empty");
    }

    @Deprecated
    public HostSpec(String hostname, Optional<ClusterMembership> membership) {
        this(hostname, new ArrayList<String>(), NodeResources.unspecified(), NodeResources.unspecified(), NodeResources.unspecified(), membership, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, ClusterMembership membership, Flavor flavor, Optional<Version> version) {
        this(hostname, new ArrayList<String>(), flavor.resources(), flavor.resources(), NodeResources.unspecified(), Optional.of(membership), version, Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases) {
        this(hostname, aliases, NodeResources.unspecified(), NodeResources.unspecified(), NodeResources.unspecified(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, Flavor flavor) {
        this(hostname, aliases, flavor.resources(), flavor.resources(), NodeResources.unspecified(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, ClusterMembership membership) {
        this(hostname, aliases, NodeResources.unspecified(), NodeResources.unspecified(), NodeResources.unspecified(), Optional.of(membership), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership) {
        this(hostname, aliases, flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), NodeResources.unspecified(), membership, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership, Optional<Version> version) {
        this(hostname, aliases, flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), NodeResources.unspecified(), membership, version, Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership, Optional<Version> version, Optional<NetworkPorts> networkPorts) {
        this(hostname, aliases, flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), NodeResources.unspecified(), membership, version, networkPorts, Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership, Optional<Version> version, Optional<NetworkPorts> networkPorts, Optional<NodeResources> requestedResources) {
        this(hostname, aliases, flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), requestedResources.orElse(NodeResources.unspecified()), membership, version, networkPorts, Optional.empty());
    }

    @Deprecated
    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership, Optional<Version> version, Optional<NetworkPorts> networkPorts, Optional<NodeResources> requestedResources, Optional<DockerImage> dockerImageRepo) {
        this(hostname, aliases, flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), flavor.map(f -> f.resources()).orElse(NodeResources.unspecified()), requestedResources.orElse(NodeResources.unspecified()), membership, version, networkPorts, dockerImageRepo);
    }

    public String hostname() {
        return this.hostname;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public NodeResources realResources() {
        return this.realResources;
    }

    public NodeResources advertisedResources() {
        return this.advertisedResources;
    }

    public Optional<Flavor> flavor() {
        return this.advertisedResources.asOptional().map(resources -> new Flavor((NodeResources)resources));
    }

    public Optional<Version> version() {
        return this.version;
    }

    public Optional<ClusterMembership> membership() {
        return this.membership;
    }

    public Optional<NetworkPorts> networkPorts() {
        return this.networkPorts;
    }

    public Optional<NodeResources> requestedResources() {
        return this.requestedResources.asOptional();
    }

    public Optional<DockerImage> dockerImageRepo() {
        return this.dockerImageRepo;
    }

    public HostSpec withPorts(Optional<NetworkPorts> ports) {
        return new HostSpec(this.hostname, this.aliases, this.realResources, this.advertisedResources, this.requestedResources, this.membership, this.version, ports, this.dockerImageRepo);
    }

    public String toString() {
        return this.hostname + (String)(!this.aliases.isEmpty() ? " (aliases: " + this.aliases + ")" : "") + (String)(this.membership.isPresent() ? " (membership: " + this.membership.get() + ")" : " (no membership)");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostSpec)) {
            return false;
        }
        return ((HostSpec)other).hostname.equals(this.hostname);
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    @Override
    public int compareTo(HostSpec other) {
        return this.hostname.compareTo(other.hostname);
    }
}

