/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Collection;
import java.util.List;

public class NetworkPorts {
    private final List<Allocation> allocations;

    public NetworkPorts(Collection<Allocation> allocations) {
        this.allocations = List.copyOf(allocations);
    }

    public Collection<Allocation> allocations() {
        return this.allocations;
    }

    public int size() {
        return this.allocations.size();
    }

    public static class Allocation {
        public final int port;
        public final String serviceType;
        public final String configId;
        public final String portSuffix;

        public Allocation(int port, String serviceType, String configId, String portSuffix) {
            this.port = port;
            this.serviceType = serviceType;
            this.configId = configId;
            this.portSuffix = portSuffix;
        }

        public String key() {
            StringBuilder buf = new StringBuilder();
            buf.append("t=").append(this.serviceType);
            buf.append(" cfg=").append(this.configId);
            buf.append(" suf=").append(this.portSuffix);
            return buf.toString();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[port=").append(this.port);
            buf.append(" serviceType=").append(this.serviceType);
            buf.append(" configId=").append(this.configId);
            buf.append(" suffix=").append(this.portSuffix);
            buf.append("]");
            return buf.toString();
        }
    }
}

