/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.text.StringUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class HostFilter {
    private final Set<String> hostnames;
    private final Set<String> flavors;
    private final Set<ClusterSpec.Type> clusterTypes;
    private final Set<ClusterSpec.Id> clusterIds;

    private HostFilter(Set<String> hostnames, Set<String> flavors, Set<ClusterSpec.Type> clusterTypes, Set<ClusterSpec.Id> clusterIds) {
        Objects.requireNonNull(hostnames, "Hostnames cannot be null, use an empty list");
        Objects.requireNonNull(flavors, "Flavors cannot be null, use an empty list");
        Objects.requireNonNull(clusterTypes, "clusterTypes cannot be null, use an empty list");
        Objects.requireNonNull(clusterIds, "clusterIds cannot be null, use an empty list");
        this.hostnames = hostnames;
        this.flavors = flavors;
        this.clusterTypes = clusterTypes;
        this.clusterIds = clusterIds;
    }

    public boolean matches(String hostname, String flavor, Optional<ClusterMembership> membership) {
        if (!this.hostnames.isEmpty() && !this.hostnames.contains(hostname)) {
            return false;
        }
        if (!this.flavors.isEmpty() && !this.flavors.contains(flavor)) {
            return false;
        }
        if (!(this.clusterTypes.isEmpty() || membership.isPresent() && this.clusterTypes.contains((Object)membership.get().cluster().type()))) {
            return false;
        }
        return this.clusterIds.isEmpty() || membership.isPresent() && this.clusterIds.contains(membership.get().cluster().id());
    }

    public static HostFilter all() {
        return new HostFilter(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public static HostFilter hostname(String hostname) {
        return new HostFilter(Collections.singleton(hostname), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public static HostFilter flavor(String flavor) {
        return new HostFilter(Collections.emptySet(), Collections.singleton(flavor), Collections.emptySet(), Collections.emptySet());
    }

    public static HostFilter clusterType(ClusterSpec.Type clusterType) {
        return new HostFilter(Collections.emptySet(), Collections.emptySet(), Collections.singleton(clusterType), Collections.emptySet());
    }

    public static HostFilter clusterId(ClusterSpec.Id clusterId) {
        return new HostFilter(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.singleton(clusterId));
    }

    public static HostFilter from(Collection<String> hostNames, Collection<String> flavors, Collection<ClusterSpec.Type> clusterTypes, Collection<ClusterSpec.Id> clusterIds) {
        return new HostFilter(Set.copyOf(hostNames), Set.copyOf(flavors), Set.copyOf(clusterTypes), Set.copyOf(clusterIds));
    }

    public static HostFilter from(String hostNames, String flavors, String clusterTypes, String clusterIds) {
        return new HostFilter(StringUtilities.split((String)hostNames), StringUtilities.split((String)flavors), StringUtilities.split((String)clusterTypes).stream().map(ClusterSpec.Type::from).collect(Collectors.toSet()), StringUtilities.split((String)clusterIds).stream().map(ClusterSpec.Id::from).collect(Collectors.toSet()));
    }
}

