/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Objects;

public class NodeResources {
    public static final NodeResources unspecified = new NodeResources(0.0, 0.0, 0.0, 0.0);
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final DiskSpeed diskSpeed;
    private final StorageType storageType;

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, DiskSpeed.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, diskSpeed, StorageType.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed, StorageType storageType) {
        this.vcpu = vcpu;
        this.memoryGb = memoryGb;
        this.diskGb = diskGb;
        this.bandwidthGbps = bandwidthGbps;
        this.diskSpeed = diskSpeed;
        this.storageType = storageType;
    }

    public double vcpu() {
        return this.vcpu;
    }

    public double memoryGb() {
        return this.memoryGb;
    }

    public double diskGb() {
        return this.diskGb;
    }

    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    public DiskSpeed diskSpeed() {
        return this.diskSpeed;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public NodeResources withVcpu(double vcpu) {
        if (vcpu == this.vcpu) {
            return this;
        }
        return new NodeResources(vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType);
    }

    public NodeResources withMemoryGb(double memoryGb) {
        if (memoryGb == this.memoryGb) {
            return this;
        }
        return new NodeResources(this.vcpu, memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType);
    }

    public NodeResources withDiskGb(double diskGb) {
        if (diskGb == this.diskGb) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType);
    }

    public NodeResources withBandwidthGbps(double bandwidthGbps) {
        if (bandwidthGbps == this.bandwidthGbps) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, bandwidthGbps, this.diskSpeed, this.storageType);
    }

    public NodeResources with(DiskSpeed diskSpeed) {
        if (diskSpeed == this.diskSpeed) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, diskSpeed, this.storageType);
    }

    public NodeResources with(StorageType storageType) {
        if (storageType == this.storageType) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, storageType);
    }

    public NodeResources justNumbers() {
        return this.with(DiskSpeed.any).with(StorageType.any);
    }

    public NodeResources subtract(NodeResources other) {
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu - other.vcpu, this.memoryGb - other.memoryGb, this.diskGb - other.diskGb, this.bandwidthGbps - other.bandwidthGbps, this.diskSpeed.combineWith(other.diskSpeed), this.storageType.combineWith(other.storageType));
    }

    public NodeResources add(NodeResources other) {
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu + other.vcpu, this.memoryGb + other.memoryGb, this.diskGb + other.diskGb, this.bandwidthGbps + other.bandwidthGbps, this.diskSpeed.combineWith(other.diskSpeed), this.storageType.combineWith(other.storageType));
    }

    private boolean isInterchangeableWith(NodeResources other) {
        if (this.diskSpeed != DiskSpeed.any && other.diskSpeed != DiskSpeed.any && this.diskSpeed != other.diskSpeed) {
            return false;
        }
        return this.storageType == StorageType.any || other.storageType == StorageType.any || this.storageType == other.storageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResources)) {
            return false;
        }
        NodeResources other = (NodeResources)o;
        if (this.vcpu != other.vcpu) {
            return false;
        }
        if (this.memoryGb != other.memoryGb) {
            return false;
        }
        if (this.diskGb != other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps != other.bandwidthGbps) {
            return false;
        }
        if (this.diskSpeed != other.diskSpeed) {
            return false;
        }
        return this.storageType == other.storageType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType});
    }

    public String toString() {
        return String.format("[vcpu: %1$.1f, memory: %2$.1f Gb, disk %3$.1f Gb" + (this.bandwidthGbps > 0.0 ? ", bandwidth: %4$.1f Gbps" : "") + (String)(!this.diskSpeed.isDefault() ? ", disk speed: " + this.diskSpeed : "") + (String)(!this.storageType.isDefault() ? ", storage type: " + this.storageType : "") + "]", this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps);
    }

    public boolean satisfies(NodeResources other) {
        if (this.vcpu < other.vcpu) {
            return false;
        }
        if (this.memoryGb < other.memoryGb) {
            return false;
        }
        if (this.diskGb < other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps < other.bandwidthGbps) {
            return false;
        }
        if (other.diskSpeed != DiskSpeed.any && other.diskSpeed != this.diskSpeed) {
            return false;
        }
        return other.storageType == StorageType.any || other.storageType == this.storageType;
    }

    public boolean compatibleWith(NodeResources other) {
        if (this.vcpu != other.vcpu) {
            return false;
        }
        if (this.memoryGb != other.memoryGb) {
            return false;
        }
        if (this.diskGb != other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps != other.bandwidthGbps) {
            return false;
        }
        if (!this.diskSpeed.compatibleWith(other.diskSpeed)) {
            return false;
        }
        return this.storageType.compatibleWith(other.storageType);
    }

    public static NodeResources fromLegacyName(String name) {
        if (!name.startsWith("d-")) {
            throw new IllegalArgumentException("A node specification string must start by 'd-' but was '" + name + "'");
        }
        String[] parts = name.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("A node specification string must contain three numbers separated by '-' but was '" + name + "'");
        }
        double cpu = Integer.parseInt(parts[1]);
        double mem = Integer.parseInt(parts[2]);
        double dsk = Integer.parseInt(parts[3]);
        if (cpu == 0.0) {
            cpu = 0.5;
        }
        if (cpu == 2.0 && mem == 8.0) {
            cpu = 1.5;
        }
        if (cpu == 2.0 && mem == 12.0) {
            cpu = 2.3;
        }
        return new NodeResources(cpu, mem, dsk, 0.3, DiskSpeed.getDefault(), StorageType.getDefault());
    }

    public static enum StorageType {
        remote,
        local,
        any;


        public static int compare(StorageType a, StorageType b) {
            if (a == any) {
                a = remote;
            }
            if (b == any) {
                b = remote;
            }
            if (a == remote && b == local) {
                return -1;
            }
            if (a == local && b == remote) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(StorageType other) {
            return this == any || other == any || other == this;
        }

        private StorageType combineWith(StorageType other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == StorageType.getDefault();
        }

        public static StorageType getDefault() {
            return any;
        }
    }

    public static enum DiskSpeed {
        fast,
        slow,
        any;


        public static int compare(DiskSpeed a, DiskSpeed b) {
            if (a == any) {
                a = slow;
            }
            if (b == any) {
                b = slow;
            }
            if (a == slow && b == fast) {
                return -1;
            }
            if (a == fast && b == slow) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(DiskSpeed other) {
            return this == any || other == any || other == this;
        }

        private DiskSpeed combineWith(DiskSpeed other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == DiskSpeed.getDefault();
        }

        public static DiskSpeed getDefault() {
            return fast;
        }
    }
}

