/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import java.util.Objects;
import java.util.Optional;

public final class ClusterSpec {
    private final Type type;
    private final Id id;
    private final Optional<Group> groupId;
    private final Version vespaVersion;
    private boolean exclusive;
    private final Optional<Id> combinedId;
    private final Optional<String> dockerImageRepo;

    private ClusterSpec(Type type, Id id, Optional<Group> groupId, Version vespaVersion, boolean exclusive, Optional<Id> combinedId, Optional<String> dockerImageRepo) {
        this.type = type;
        this.id = id;
        this.groupId = groupId;
        this.vespaVersion = vespaVersion;
        this.exclusive = exclusive;
        if (type != Type.combined && combinedId.isPresent()) {
            throw new IllegalArgumentException("combinedId must be empty for cluster of type " + type);
        }
        this.combinedId = combinedId;
        this.dockerImageRepo = dockerImageRepo;
    }

    public Type type() {
        return this.type;
    }

    public Id id() {
        return this.id;
    }

    public Optional<String> dockerImageRepo() {
        return this.dockerImageRepo;
    }

    public Optional<String> dockerImage() {
        return this.dockerImageRepo.map(repo -> repo + ":" + this.vespaVersion.toFullString());
    }

    public Version vespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Group> group() {
        return this.groupId;
    }

    public Optional<Id> combinedId() {
        return this.combinedId;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public ClusterSpec with(Optional<Group> newGroup) {
        return new ClusterSpec(this.type, this.id, newGroup, this.vespaVersion, this.exclusive, this.combinedId, this.dockerImageRepo);
    }

    public ClusterSpec exclusive(boolean exclusive) {
        return new ClusterSpec(this.type, this.id, this.groupId, this.vespaVersion, exclusive, this.combinedId, this.dockerImageRepo);
    }

    public static ClusterSpec request(Type type, Id id, Version vespaVersion, boolean exclusive, Optional<Id> combinedId, Optional<String> dockerImageRepo) {
        return new ClusterSpec(type, id, Optional.empty(), vespaVersion, exclusive, combinedId, dockerImageRepo);
    }

    public static ClusterSpec from(Type type, Id id, Group groupId, Version vespaVersion, boolean exclusive, Optional<Id> combinedId, Optional<String> dockerImageRepo) {
        return new ClusterSpec(type, id, Optional.of(groupId), vespaVersion, exclusive, combinedId, dockerImageRepo);
    }

    public static Builder request(Type type, Id id) {
        return new Builder(type, id, false);
    }

    public static Builder specification(Type type, Id id) {
        return new Builder(type, id, true);
    }

    public String toString() {
        return this.type + " " + this.id + " " + this.groupId.map(group -> group + " ").orElse("") + this.vespaVersion + this.dockerImageRepo.map(repo -> " " + repo).orElse("");
    }

    public int hashCode() {
        return this.type.hashCode() + 17 * this.id.hashCode() + 31 * this.groupId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterSpec)) {
            return false;
        }
        ClusterSpec other = (ClusterSpec)o;
        if (!other.type.equals((Object)this.type)) {
            return false;
        }
        if (!other.id.equals(this.id)) {
            return false;
        }
        if (!other.groupId.equals(this.groupId)) {
            return false;
        }
        if (!other.vespaVersion.equals((Object)this.vespaVersion)) {
            return false;
        }
        return other.dockerImageRepo.orElse("").equals(this.dockerImageRepo.orElse(""));
    }

    public boolean satisfies(ClusterSpec other) {
        if (!other.id.equals(this.id)) {
            return false;
        }
        if (other.type.isContent() || this.type.isContent()) {
            return other.type.isContent() == this.type.isContent();
        }
        return other.type.equals((Object)this.type);
    }

    public static final class Group {
        private final int index;

        private Group(int index) {
            this.index = index;
        }

        public static Group from(int index) {
            return new Group(index);
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return "group " + this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Group)o).index == this.index;
        }

        public int hashCode() {
            return this.index;
        }
    }

    public static final class Id {
        private final String id;

        public Id(String id) {
            Objects.requireNonNull(id, "Id cannot be null");
            this.id = id;
        }

        public static Id from(String id) {
            return new Id(id);
        }

        public String value() {
            return this.id;
        }

        public String toString() {
            return "cluster '" + this.id + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Id)o).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static enum Type {
        admin,
        container,
        content,
        combined;


        public boolean isContent() {
            return this == content || this == combined;
        }

        public boolean isContainer() {
            return this == container || this == combined;
        }

        public static Type from(String typeName) {
            switch (typeName) {
                case "admin": {
                    return admin;
                }
                case "container": {
                    return container;
                }
                case "content": {
                    return content;
                }
                case "combined": {
                    return combined;
                }
            }
            throw new IllegalArgumentException("Illegal cluster type '" + typeName + "'");
        }
    }

    public static class Builder {
        private final Type type;
        private final Id id;
        private final boolean specification;
        private Optional<Group> groupId = Optional.empty();
        private Optional<String> dockerImageRepo = Optional.empty();
        private Version vespaVersion;
        private boolean exclusive = false;
        private Optional<Id> combinedId = Optional.empty();

        Builder(Type type, Id id, boolean specification) {
            this.type = type;
            this.id = id;
            this.specification = specification;
        }

        public ClusterSpec build() {
            if (this.specification) {
                if (this.groupId.isEmpty()) {
                    throw new IllegalArgumentException("groupIs is required to be set when creating a ClusterSpec with specification()");
                }
                if (this.vespaVersion == null) {
                    throw new IllegalArgumentException("vespaVersion is required to be set when creating a ClusterSpec with specification()");
                }
            } else if (this.groupId.isPresent()) {
                throw new IllegalArgumentException("groupId is not allowed to be set when creating a ClusterSpec with request()");
            }
            return new ClusterSpec(this.type, this.id, this.groupId, this.vespaVersion, this.exclusive, this.combinedId, this.dockerImageRepo);
        }

        public Builder group(Group groupId) {
            this.groupId = Optional.ofNullable(groupId);
            return this;
        }

        public Builder vespaVersion(Version vespaVersion) {
            this.vespaVersion = vespaVersion;
            return this;
        }

        public Builder vespaVersion(String vespaVersion) {
            this.vespaVersion = Version.fromString((String)vespaVersion);
            return this;
        }

        public Builder exclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public Builder combinedId(Optional<Id> combinedId) {
            this.combinedId = combinedId;
            return this;
        }

        public Builder dockerImageRepo(Optional<String> dockerImageRepo) {
            this.dockerImageRepo = dockerImageRepo;
            return this;
        }
    }
}

