/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeResources;
import java.util.Objects;

public class ClusterResources {
    private final int nodes;
    private final int groups;
    private final NodeResources nodeResources;

    public ClusterResources(int nodes, int groups, NodeResources nodeResources) {
        if (nodes > 0 && groups > 0 && nodes % groups != 0) {
            throw new IllegalArgumentException("The number of nodes (" + nodes + ") must be divisible by the number of groups (" + groups + ")");
        }
        this.nodes = nodes;
        this.groups = groups;
        this.nodeResources = Objects.requireNonNull(nodeResources);
    }

    public int nodes() {
        return this.nodes;
    }

    public int groups() {
        return this.groups;
    }

    public NodeResources nodeResources() {
        return this.nodeResources;
    }

    public ClusterResources with(NodeResources resources) {
        return new ClusterResources(this.nodes, this.groups, resources);
    }

    public ClusterResources withGroups(int groups) {
        return new ClusterResources(this.nodes, groups, this.nodeResources);
    }

    public boolean smallerThan(ClusterResources other) {
        if (this.nodes < other.nodes) {
            return true;
        }
        if (this.groups < other.groups) {
            return true;
        }
        return !this.nodeResources.justNumbers().satisfies(other.nodeResources.justNumbers());
    }

    public boolean isWithin(ClusterResources min, ClusterResources max) {
        if (this.smallerThan(min)) {
            return false;
        }
        return !max.smallerThan(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterResources)) {
            return false;
        }
        ClusterResources other = (ClusterResources)o;
        if (other.nodes != this.nodes) {
            return false;
        }
        if (other.groups != this.groups) {
            return false;
        }
        return other.nodeResources.equals(this.nodeResources);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.groups, this.nodeResources);
    }

    public String toString() {
        return this.nodes + " nodes" + (String)(this.groups > 1 ? " (in " + this.groups + " groups)" : "") + " with " + this.nodeResources;
    }
}

