/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import java.util.Optional;

public final class Capacity {
    private final ClusterResources min;
    private final ClusterResources max;
    private final boolean required;
    private final boolean canFail;
    private final NodeType type;

    private Capacity(ClusterResources min, ClusterResources max, boolean required, boolean canFail, NodeType type) {
        if (max.smallerThan(min)) {
            throw new IllegalArgumentException("The max capacity must be larger than the min capacity, but got min " + min + " and max " + max);
        }
        this.min = min;
        this.max = max;
        this.required = required;
        this.canFail = canFail;
        this.type = type;
    }

    @Deprecated
    public int nodeCount() {
        return this.min.nodes();
    }

    @Deprecated
    public int nodes() {
        return this.min.nodes();
    }

    @Deprecated
    public int groups() {
        return this.min.groups();
    }

    @Deprecated
    public Optional<String> flavor() {
        if (this.nodeResources().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.min.nodeResources().toString());
    }

    @Deprecated
    public Optional<NodeResources> nodeResources() {
        if (this.min.nodeResources() == NodeResources.unspecified) {
            return Optional.empty();
        }
        return Optional.of(this.min.nodeResources());
    }

    public ClusterResources minResources() {
        return this.min;
    }

    public ClusterResources maxResources() {
        return this.max;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canFail() {
        return this.canFail;
    }

    public NodeType type() {
        return this.type;
    }

    public Capacity withGroups(int groups) {
        return new Capacity(this.min.withGroups(groups), this.max.withGroups(groups), this.required, this.canFail, this.type);
    }

    public String toString() {
        return (this.required ? "required " : "") + (this.min.equals(this.max) ? this.min : "between " + this.min + " and " + this.max);
    }

    public static Capacity from(ClusterResources resources) {
        return Capacity.from(resources, false, true);
    }

    public static Capacity from(ClusterResources resources, boolean required, boolean canFail) {
        return Capacity.from(resources, required, canFail, NodeType.tenant);
    }

    public static Capacity from(ClusterResources min, ClusterResources max, boolean required, boolean canFail) {
        return new Capacity(min, max, required, canFail, NodeType.tenant);
    }

    @Deprecated
    public static Capacity fromCount(int nodes, NodeResources resources) {
        return Capacity.fromCount(nodes, resources, false, true);
    }

    @Deprecated
    public static Capacity fromCount(int nodes, NodeResources resources, boolean required, boolean canFail) {
        return Capacity.fromCount(nodes, Optional.of(resources), required, canFail);
    }

    @Deprecated
    public static Capacity fromCount(int nodes, Optional<NodeResources> resources, boolean required, boolean canFail) {
        return Capacity.from(new ClusterResources(nodes, 0, resources.orElse(NodeResources.unspecified)), required, canFail, NodeType.tenant);
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return Capacity.from(new ClusterResources(0, 0, NodeResources.unspecified), true, false, type);
    }

    private static Capacity from(ClusterResources resources, boolean required, boolean canFail, NodeType type) {
        return new Capacity(resources, resources, required, canFail, type);
    }
}

