/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import java.util.Optional;

public final class Capacity {
    private final int nodeCount;
    private final boolean required;
    private final boolean canFail;
    private final Optional<NodeResources> nodeResources;
    private final NodeType type;

    private Capacity(int nodeCount, Optional<NodeResources> nodeResources, boolean required, boolean canFail, NodeType type) {
        this.nodeCount = nodeCount;
        this.required = required;
        this.canFail = canFail;
        this.nodeResources = nodeResources;
        this.type = type;
    }

    public int nodeCount() {
        return this.nodeCount;
    }

    @Deprecated
    public Optional<String> flavor() {
        if (this.nodeResources().isEmpty()) {
            return Optional.empty();
        }
        return this.nodeResources.map(n -> n.toString());
    }

    public Optional<NodeResources> nodeResources() {
        return this.nodeResources;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canFail() {
        return this.canFail;
    }

    public NodeType type() {
        return this.type;
    }

    public String toString() {
        return this.nodeCount + " nodes " + (this.nodeResources.isPresent() ? this.nodeResources.get() : "with default resources");
    }

    public static Capacity fromNodeCount(int capacity) {
        return Capacity.fromCount(capacity, Optional.empty(), false, true);
    }

    public static Capacity fromCount(int nodeCount, NodeResources resources) {
        return Capacity.fromCount(nodeCount, resources, false, true);
    }

    public static Capacity fromCount(int nodeCount, NodeResources resources, boolean required, boolean canFail) {
        return new Capacity(nodeCount, Optional.of(resources), required, canFail, NodeType.tenant);
    }

    public static Capacity fromCount(int nodeCount, Optional<NodeResources> resources, boolean required, boolean canFail) {
        return new Capacity(nodeCount, resources, required, canFail, NodeType.tenant);
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return new Capacity(0, Optional.empty(), true, false, type);
    }
}

