/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Objects;

public class CloudName
implements Comparable<CloudName> {
    private static final CloudName defaultCloud = CloudName.from("default");
    private final String cloud;

    private CloudName(String cloud) {
        this.cloud = cloud;
    }

    public String value() {
        return this.cloud;
    }

    public boolean isDefault() {
        return CloudName.defaultName().equals(this);
    }

    public static CloudName defaultName() {
        return defaultCloud;
    }

    public static CloudName from(String cloud) {
        return new CloudName(cloud);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudName cloudName = (CloudName)o;
        return Objects.equals(this.cloud, cloudName.cloud);
    }

    public int hashCode() {
        return Objects.hash(this.cloud);
    }

    public String toString() {
        return this.cloud;
    }

    @Override
    public int compareTo(CloudName o) {
        return this.cloud.compareTo(o.cloud);
    }
}

