/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.collect.ImmutableList;
import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.Flavor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HostSpec
implements Comparable<HostSpec> {
    private final String hostname;
    private final ImmutableList<String> aliases;
    private final Optional<ClusterMembership> membership;
    private final Optional<Flavor> flavor;
    private final Optional<Version> version;

    public HostSpec(String hostname, Optional<ClusterMembership> membership) {
        this(hostname, new ArrayList<String>(), Optional.empty(), membership);
    }

    public HostSpec(String hostname, ClusterMembership membership, Flavor flavor, Optional<Version> version) {
        this(hostname, new ArrayList<String>(), Optional.of(flavor), Optional.of(membership), version);
    }

    public HostSpec(String hostname, List<String> aliases) {
        this(hostname, aliases, Optional.empty(), Optional.empty());
    }

    public HostSpec(String hostname, List<String> aliases, Flavor flavor) {
        this(hostname, aliases, Optional.of(flavor), Optional.empty());
    }

    public HostSpec(String hostname, List<String> aliases, ClusterMembership membership) {
        this(hostname, aliases, Optional.empty(), Optional.of(membership));
    }

    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership) {
        this(hostname, aliases, flavor, membership, Optional.empty());
    }

    public HostSpec(String hostname, List<String> aliases, Optional<Flavor> flavor, Optional<ClusterMembership> membership, Optional<Version> version) {
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("Hostname must be specified");
        }
        Objects.requireNonNull(version, "Version cannot be null but can be empty");
        this.hostname = hostname;
        this.aliases = ImmutableList.copyOf(aliases);
        this.flavor = flavor;
        this.membership = membership;
        this.version = version;
    }

    public String hostname() {
        return this.hostname;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public Optional<Flavor> flavor() {
        return this.flavor;
    }

    public Optional<Version> version() {
        return this.version;
    }

    public Optional<ClusterMembership> membership() {
        return this.membership;
    }

    public String toString() {
        return this.hostname + (String)(!this.aliases.isEmpty() ? " (aliases: " + this.aliases + ")" : "") + (String)(this.membership.isPresent() ? " (membership: " + this.membership.get() + ")" : " (no membership)");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostSpec)) {
            return false;
        }
        return ((HostSpec)other).hostname.equals(this.hostname);
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    @Override
    public int compareTo(HostSpec other) {
        return this.hostname.compareTo(other.hostname);
    }
}

