/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.host.FlavorOverrides;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.Objects;
import java.util.Optional;

public class Flavor {
    private final boolean configured;
    private final String name;
    private final int cost;
    private final Type type;
    private final NodeResources resources;
    private final double minCpuCores;
    private final Optional<FlavorOverrides> flavorOverrides;
    private static final double cpuSpeedupRolloutFactor = 0.6666666666666666;

    public Flavor(FlavorsConfig.Flavor flavorConfig) {
        this(flavorConfig.name(), new NodeResources(flavorConfig.minCpuCores() * (1.0 + (flavorConfig.cpuSpeedup() - 1.0) * 0.6666666666666666), flavorConfig.minMainMemoryAvailableGb(), flavorConfig.minDiskAvailableGb(), flavorConfig.bandwidth() / 1000.0, flavorConfig.fastDisk() ? NodeResources.DiskSpeed.fast : NodeResources.DiskSpeed.slow, flavorConfig.remoteStorage() ? NodeResources.StorageType.remote : NodeResources.StorageType.local), Optional.empty(), Type.valueOf(flavorConfig.environment()), true, flavorConfig.cost(), flavorConfig.minCpuCores());
    }

    public Flavor(NodeResources resources) {
        this(resources.toString(), resources, Optional.empty(), Type.DOCKER_CONTAINER, false, 0, resources.vcpu());
    }

    private Flavor(String name, NodeResources resources, Optional<FlavorOverrides> flavorOverrides, Type type, boolean configured, int cost, double minCpuCores) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        this.resources = Objects.requireNonNull(resources, "Resources cannot be null");
        this.flavorOverrides = Objects.requireNonNull(flavorOverrides, "Flavor overrides cannot be null");
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        this.configured = configured;
        this.cost = cost;
        this.minCpuCores = minCpuCores;
    }

    public Flavor with(FlavorOverrides flavorOverrides) {
        if (!this.configured) {
            throw new IllegalArgumentException("Cannot override non-configured flavor");
        }
        NodeResources newResources = this.resources.withDiskGb(flavorOverrides.diskGb().orElseGet(this.resources::diskGb));
        return new Flavor(this.name, newResources, Optional.of(flavorOverrides), this.type, true, this.cost, this.minCpuCores);
    }

    public Flavor with(NodeResources resources) {
        if (this.type == Type.DOCKER_CONTAINER && !this.configured) {
            return new Flavor(resources);
        }
        if (!resources.equals(this.resources.withDiskGb(resources.diskGb()))) {
            throw new IllegalArgumentException("Can only override disk GB for configured flavor");
        }
        return this.with(FlavorOverrides.ofDisk(resources.diskGb()));
    }

    public String name() {
        return this.name;
    }

    public int cost() {
        return this.cost;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public NodeResources resources() {
        return this.resources;
    }

    public Optional<FlavorOverrides> flavorOverrides() {
        return this.flavorOverrides;
    }

    public double getMinMainMemoryAvailableGb() {
        return this.resources.memoryGb();
    }

    public double getMinDiskAvailableGb() {
        return this.resources.diskGb();
    }

    public boolean hasFastDisk() {
        return this.resources.diskSpeed() == NodeResources.DiskSpeed.fast;
    }

    public double getBandwidthGbps() {
        return this.resources.bandwidthGbps();
    }

    public double getMinCpuCores() {
        return this.minCpuCores;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDocker() {
        return this.type == Type.DOCKER_CONTAINER;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.flavorOverrides);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flavor)) {
            return false;
        }
        Flavor other = (Flavor)o;
        if (this.configured) {
            return Objects.equals(this.name, other.name) && Objects.equals(this.flavorOverrides, other.flavorOverrides);
        }
        return this.resources.equals(other.resources);
    }

    public String toString() {
        if (this.isConfigured()) {
            return "flavor '" + this.name + "'" + this.flavorOverrides.map(o -> " with overrides: " + o).orElse("");
        }
        return this.name;
    }

    public static enum Type {
        undefined,
        BARE_METAL,
        VIRTUAL_MACHINE,
        DOCKER_CONTAINER;

    }
}

