/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import java.util.Objects;
import java.util.Optional;

public class DockerImage {
    public static final DockerImage EMPTY = new DockerImage("", Optional.empty());
    private final String repository;
    private final Optional<String> tag;

    private DockerImage(String repository, Optional<String> tag) {
        this.repository = Objects.requireNonNull(repository, "repository must be non-null");
        this.tag = Objects.requireNonNull(tag, "tag must be non-null");
    }

    public String repository() {
        return this.repository;
    }

    public Optional<String> tag() {
        return this.tag;
    }

    public Version tagAsVersion() {
        return this.tag.map(Version::new).orElse(Version.emptyVersion);
    }

    public DockerImage withTag(Version version) {
        return new DockerImage(this.repository, Optional.of(version.toFullString()));
    }

    public String asString() {
        return this.repository + this.tag.map(t -> ":" + t).orElse("");
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerImage that = (DockerImage)o;
        return this.repository.equals(that.repository) && this.tag.equals(that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.tag);
    }

    public static DockerImage fromString(String name) {
        if (name.isEmpty()) {
            return EMPTY;
        }
        int n = name.lastIndexOf(58);
        if (n < 0) {
            return new DockerImage(name, Optional.empty());
        }
        String tag = name.substring(n + 1);
        if (!tag.contains("/")) {
            return new DockerImage(name.substring(0, n), Optional.of(tag));
        }
        return new DockerImage(name, Optional.empty());
    }
}

