/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Objects;

public class NodeResources {
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final DiskSpeed diskSpeed;

    @Deprecated
    public NodeResources(double vcpu, double memoryGb, double diskGb) {
        this(vcpu, memoryGb, diskGb, DiskSpeed.fast);
    }

    @Deprecated
    public NodeResources(double vcpu, double memoryGb, double diskGb, DiskSpeed diskSpeed) {
        this(vcpu, memoryGb, diskGb, 0.3, diskSpeed);
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, DiskSpeed.fast);
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed) {
        this.vcpu = vcpu;
        this.memoryGb = memoryGb;
        this.diskGb = diskGb;
        this.bandwidthGbps = bandwidthGbps;
        this.diskSpeed = diskSpeed;
    }

    public double vcpu() {
        return this.vcpu;
    }

    public double memoryGb() {
        return this.memoryGb;
    }

    public double diskGb() {
        return this.diskGb;
    }

    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    public DiskSpeed diskSpeed() {
        return this.diskSpeed;
    }

    public NodeResources withVcpu(double vcpu) {
        return new NodeResources(vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed);
    }

    public NodeResources withMemoryGb(double memoryGb) {
        return new NodeResources(this.vcpu, memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed);
    }

    public NodeResources withDiskGb(double diskGb) {
        return new NodeResources(this.vcpu, this.memoryGb, diskGb, this.bandwidthGbps, this.diskSpeed);
    }

    public NodeResources withBandwidthGbps(double bandwidthGbps) {
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, bandwidthGbps, this.diskSpeed);
    }

    public NodeResources withDiskSpeed(DiskSpeed speed) {
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, speed);
    }

    public NodeResources subtract(NodeResources other) {
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu - other.vcpu, this.memoryGb - other.memoryGb, this.diskGb - other.diskGb, this.bandwidthGbps - other.bandwidthGbps, this.combine(this.diskSpeed, other.diskSpeed));
    }

    public NodeResources add(NodeResources other) {
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu + other.vcpu, this.memoryGb + other.memoryGb, this.diskGb + other.diskGb, this.bandwidthGbps + other.bandwidthGbps, this.combine(this.diskSpeed, other.diskSpeed));
    }

    private boolean isInterchangeableWith(NodeResources other) {
        return this.diskSpeed == DiskSpeed.any || other.diskSpeed == DiskSpeed.any || this.diskSpeed == other.diskSpeed;
    }

    private DiskSpeed combine(DiskSpeed a, DiskSpeed b) {
        if (a == DiskSpeed.any) {
            return b;
        }
        if (b == DiskSpeed.any) {
            return a;
        }
        if (a == b) {
            return a;
        }
        throw new IllegalArgumentException(a + " cannot be combined with " + b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResources)) {
            return false;
        }
        NodeResources other = (NodeResources)o;
        if (this.vcpu != other.vcpu) {
            return false;
        }
        if (this.memoryGb != other.memoryGb) {
            return false;
        }
        if (this.diskGb != other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps != other.bandwidthGbps) {
            return false;
        }
        return this.diskSpeed == other.diskSpeed;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed});
    }

    public String toString() {
        return "[vcpu: " + this.vcpu + ", memory: " + this.memoryGb + " Gb, disk " + this.diskGb + " Gb" + (String)(this.bandwidthGbps > 0.0 ? ", bandwidth: " + this.bandwidthGbps + " Gbps" : "") + (String)(this.diskSpeed != DiskSpeed.fast ? ", disk speed: " + this.diskSpeed : "") + "]";
    }

    public boolean satisfies(NodeResources other) {
        if (this.vcpu < other.vcpu) {
            return false;
        }
        if (this.memoryGb < other.memoryGb) {
            return false;
        }
        if (this.diskGb < other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps < other.bandwidthGbps) {
            return false;
        }
        return other.diskSpeed == DiskSpeed.any || other.diskSpeed == this.diskSpeed;
    }

    public boolean compatibleWith(NodeResources other) {
        if (this.vcpu != other.vcpu) {
            return false;
        }
        if (this.memoryGb != other.memoryGb) {
            return false;
        }
        if (this.diskGb != other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps != other.bandwidthGbps) {
            return false;
        }
        return other.diskSpeed == DiskSpeed.any || other.diskSpeed == this.diskSpeed;
    }

    public static NodeResources fromLegacyName(String name) {
        if (!name.startsWith("d-")) {
            throw new IllegalArgumentException("A node specification string must start by 'd-' but was '" + name + "'");
        }
        String[] parts = name.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("A node specification string must contain three numbers separated by '-' but was '" + name + "'");
        }
        double cpu = Integer.parseInt(parts[1]);
        double mem = Integer.parseInt(parts[2]);
        double dsk = Integer.parseInt(parts[3]);
        if (cpu == 0.0) {
            cpu = 0.5;
        }
        if (cpu == 2.0 && mem == 8.0) {
            cpu = 1.5;
        }
        if (cpu == 2.0 && mem == 12.0) {
            cpu = 2.3;
        }
        return new NodeResources(cpu, mem, dsk, 0.3, DiskSpeed.fast);
    }

    public static enum DiskSpeed {
        fast,
        slow,
        any;

    }
}

