/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.host.FlavorOverrides;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.Objects;
import java.util.Optional;

public class Flavor {
    private final boolean configured;
    private final String name;
    private final int cost;
    private final Type type;
    private final NodeResources resources;
    private final Optional<FlavorOverrides> flavorOverrides;

    public Flavor(FlavorsConfig.Flavor flavorConfig) {
        this(flavorConfig.name(), new NodeResources(flavorConfig.minCpuCores(), flavorConfig.minMainMemoryAvailableGb(), flavorConfig.minDiskAvailableGb(), flavorConfig.bandwidth() / 1000.0, flavorConfig.fastDisk() ? NodeResources.DiskSpeed.fast : NodeResources.DiskSpeed.slow), Optional.empty(), Type.valueOf(flavorConfig.environment()), true, flavorConfig.cost());
    }

    public Flavor(NodeResources resources) {
        this(resources.toString(), resources, Optional.empty(), Type.DOCKER_CONTAINER, false, 0);
    }

    private Flavor(String name, NodeResources resources, Optional<FlavorOverrides> flavorOverrides, Type type, boolean configured, int cost) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        this.resources = Objects.requireNonNull(resources, "Resources cannot be null");
        this.flavorOverrides = Objects.requireNonNull(flavorOverrides, "Flavor overrides cannot be null");
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        this.configured = configured;
        this.cost = cost;
    }

    public Flavor with(FlavorOverrides flavorOverrides) {
        if (!this.configured) {
            throw new IllegalArgumentException("Cannot override non-configured flavor");
        }
        NodeResources newResources = new NodeResources(this.resources.vcpu(), this.resources.memoryGb(), flavorOverrides.diskGb().orElseGet(this.resources::diskGb), this.resources.bandwidthGbps(), this.resources.diskSpeed());
        return new Flavor(this.name, newResources, Optional.of(flavorOverrides), this.type, true, this.cost);
    }

    public Flavor with(NodeResources resources) {
        if (this.type == Type.DOCKER_CONTAINER && !this.configured) {
            return new Flavor(resources);
        }
        if (!resources.equals(this.resources.withDiskGb(resources.diskGb()))) {
            throw new IllegalArgumentException("Can only override disk GB for configured flavor");
        }
        return this.with(FlavorOverrides.ofDisk(resources.diskGb()));
    }

    public String name() {
        return this.name;
    }

    public int cost() {
        return this.cost;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public NodeResources resources() {
        return this.resources;
    }

    public Optional<FlavorOverrides> flavorOverrides() {
        return this.flavorOverrides;
    }

    public double getMinMainMemoryAvailableGb() {
        return this.resources.memoryGb();
    }

    public double getMinDiskAvailableGb() {
        return this.resources.diskGb();
    }

    public boolean hasFastDisk() {
        return this.resources.diskSpeed() == NodeResources.DiskSpeed.fast;
    }

    public double getBandwidthGbps() {
        return this.resources.bandwidthGbps();
    }

    public double getMinCpuCores() {
        return this.resources.vcpu();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDocker() {
        return this.type == Type.DOCKER_CONTAINER;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.flavorOverrides);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flavor)) {
            return false;
        }
        Flavor other = (Flavor)o;
        if (this.configured) {
            return Objects.equals(this.name, other.name) && Objects.equals(this.flavorOverrides, other.flavorOverrides);
        }
        return this.resources.equals(other.resources);
    }

    public String toString() {
        if (this.isConfigured()) {
            return "flavor '" + this.name + "'" + this.flavorOverrides.map(o -> " with overrides: " + o).orElse("");
        }
        return this.name;
    }

    public static enum Type {
        undefined,
        BARE_METAL,
        VIRTUAL_MACHINE,
        DOCKER_CONTAINER;

    }
}

