/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.collect.ImmutableSet;
import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class AllocatedHosts {
    private static final String mappingKey = "mapping";
    private static final String hostSpecKey = "hostSpec";
    private static final String hostSpecHostName = "hostName";
    private static final String hostSpecMembership = "membership";
    private static final String hostSpecFlavor = "flavor";
    private static final String hostSpecVespaVersion = "vespaVersion";
    private static final String hostSpecCurrentVespaVersion = "currentVespaVersion";
    private final ImmutableSet<HostSpec> hosts;

    AllocatedHosts(Set<HostSpec> hosts) {
        this.hosts = ImmutableSet.copyOf(hosts);
    }

    public static AllocatedHosts withHosts(Set<HostSpec> hosts) {
        return new AllocatedHosts(hosts);
    }

    private void toSlime(Cursor cursor) {
        Cursor array = cursor.setArray(mappingKey);
        for (HostSpec host : this.hosts) {
            this.toSlime(host, array.addObject().setObject(hostSpecKey));
        }
    }

    private void toSlime(HostSpec host, Cursor cursor) {
        cursor.setString(hostSpecHostName, host.hostname());
        host.membership().ifPresent(membership -> {
            cursor.setString(hostSpecMembership, membership.stringValue());
            cursor.setString(hostSpecVespaVersion, membership.cluster().vespaVersion().toFullString());
        });
        host.flavor().ifPresent(flavor -> cursor.setString(hostSpecFlavor, flavor.name()));
        host.version().ifPresent(version -> cursor.setString(hostSpecCurrentVespaVersion, version.toFullString()));
    }

    public Set<HostSpec> getHosts() {
        return this.hosts;
    }

    private static AllocatedHosts fromSlime(Inspector inspector, final Optional<NodeFlavors> nodeFlavors) {
        Inspector array = inspector.field(mappingKey);
        final LinkedHashSet<HostSpec> hosts = new LinkedHashSet<HostSpec>();
        array.traverse(new ArrayTraverser(){

            public void entry(int i, Inspector inspector) {
                hosts.add(AllocatedHosts.hostFromSlime(inspector.field(AllocatedHosts.hostSpecKey), nodeFlavors));
            }
        });
        return new AllocatedHosts(hosts);
    }

    static HostSpec hostFromSlime(Inspector object, Optional<NodeFlavors> nodeFlavors) {
        Optional<ClusterMembership> membership = object.field(hostSpecMembership).valid() ? Optional.of(AllocatedHosts.membershipFromSlime(object)) : Optional.empty();
        Optional<Flavor> flavor = object.field(hostSpecFlavor).valid() ? AllocatedHosts.flavorFromSlime(object, nodeFlavors) : Optional.empty();
        Optional<Version> version = AllocatedHosts.optionalString(object.field(hostSpecCurrentVespaVersion)).map(Version::new);
        return new HostSpec(object.field(hostSpecHostName).asString(), Collections.emptyList(), flavor, membership, version);
    }

    private static ClusterMembership membershipFromSlime(Inspector object) {
        return ClusterMembership.from(object.field(hostSpecMembership).asString(), Version.fromString((String)object.field(hostSpecVespaVersion).asString()));
    }

    private static Optional<Flavor> flavorFromSlime(Inspector object, Optional<NodeFlavors> nodeFlavors) {
        return nodeFlavors.map(flavorMapper -> flavorMapper.getFlavor(object.field(hostSpecFlavor).asString())).orElse(Optional.empty());
    }

    private static Optional<String> optionalString(Inspector inspector) {
        if (!inspector.valid()) {
            return Optional.empty();
        }
        return Optional.of(inspector.asString());
    }

    public byte[] toJson() throws IOException {
        Slime slime = new Slime();
        this.toSlime(slime.setObject());
        return SlimeUtils.toJsonBytes((Slime)slime);
    }

    public static AllocatedHosts fromJson(byte[] json, Optional<NodeFlavors> nodeFlavors) {
        return AllocatedHosts.fromSlime((Inspector)SlimeUtils.jsonToSlime((byte[])json).get(), nodeFlavors);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AllocatedHosts)) {
            return false;
        }
        return ((AllocatedHosts)other).hosts.equals(this.hosts);
    }

    public int hashCode() {
        return this.hosts.hashCode();
    }

    public String toString() {
        return this.hosts.toString();
    }
}

