/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeType;
import java.util.Optional;

public final class Capacity {
    private final int nodeCount;
    private final boolean required;
    private final boolean canFail;
    private final Optional<String> flavor;
    private final NodeType type;

    private Capacity(int nodeCount, Optional<String> flavor, boolean required, boolean canFail, NodeType type) {
        this.nodeCount = nodeCount;
        this.required = required;
        this.canFail = canFail;
        this.flavor = flavor;
        this.type = type;
    }

    public int nodeCount() {
        return this.nodeCount;
    }

    public Optional<String> flavor() {
        return this.flavor;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canFail() {
        return this.canFail;
    }

    public NodeType type() {
        return this.type;
    }

    public String toString() {
        return this.nodeCount + " nodes " + (this.flavor.isPresent() ? "of flavor " + this.flavor.get() : "(default flavor)");
    }

    public static Capacity fromNodeCount(int capacity) {
        return Capacity.fromNodeCount(capacity, Optional.empty(), false, true);
    }

    @Deprecated
    public static Capacity fromNodeCount(int nodeCount, Optional<String> flavor, boolean required) {
        return new Capacity(nodeCount, flavor, required, true, NodeType.tenant);
    }

    public static Capacity fromNodeCount(int nodeCount, Optional<String> flavor, boolean required, boolean canFail) {
        return new Capacity(nodeCount, flavor, required, canFail, NodeType.tenant);
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return new Capacity(0, Optional.empty(), true, false, type);
    }
}

