/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NodeFlavors {
    private final ImmutableMap<String, Flavor> flavors;

    @Inject
    public NodeFlavors(FlavorsConfig config) {
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        for (Flavor flavor : NodeFlavors.toFlavors(config)) {
            b.put((Object)flavor.name(), (Object)flavor);
        }
        this.flavors = b.build();
    }

    public List<Flavor> getFlavors() {
        return new ArrayList<Flavor>((Collection<Flavor>)this.flavors.values());
    }

    public Optional<Flavor> getFlavor(String name) {
        return Optional.ofNullable(this.flavors.get((Object)name));
    }

    public Flavor getFlavorOrThrow(String flavorName) {
        return this.getFlavor(flavorName).orElseThrow(() -> new IllegalArgumentException("Unknown flavor '" + flavorName + "'. Flavors are " + this.canonicalFlavorNames()));
    }

    private List<String> canonicalFlavorNames() {
        return this.flavors.values().stream().map(Flavor::canonicalName).distinct().sorted().collect(Collectors.toList());
    }

    private static Collection<Flavor> toFlavors(FlavorsConfig config) {
        HashMap<String, Flavor> flavors = new HashMap<String, Flavor>();
        for (FlavorsConfig.Flavor flavorConfig : config.flavor()) {
            flavors.put(flavorConfig.name(), new Flavor(flavorConfig));
        }
        for (FlavorsConfig.Flavor flavorConfig : config.flavor()) {
            Flavor flavor = (Flavor)flavors.get(flavorConfig.name());
            for (FlavorsConfig.Flavor.Replaces flavorReplacesConfig : flavorConfig.replaces()) {
                if (!flavors.containsKey(flavorReplacesConfig.name())) {
                    throw new IllegalStateException("Replaces for " + flavor.name() + " pointing to a non existing flavor: " + flavorReplacesConfig.name());
                }
                flavor.replaces().add((Flavor)flavors.get(flavorReplacesConfig.name()));
            }
            flavor.freeze();
        }
        for (Flavor flavor : flavors.values()) {
            if (!flavor.isRetired() || NodeFlavors.hasReplacement(flavors.values(), flavor)) continue;
            throw new IllegalStateException(String.format("Flavor '%s' is retired, but has no replacement", flavor.name()));
        }
        return flavors.values();
    }

    private static boolean hasReplacement(Collection<Flavor> flavors, Flavor flavor) {
        return flavors.stream().filter(f -> !f.equals(flavor)).anyMatch(f -> f.satisfies(flavor));
    }
}

