/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String stringValue;

    private Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.stringValue = this.toSerializedForm();
        this.verify();
    }

    private Version(String versionString) {
        try {
            String[] components = versionString.split("\\.", 3);
            assert (components.length == 3);
            this.major = Integer.parseInt(components[0]);
            this.minor = Integer.parseInt(components[1]);
            this.micro = Integer.parseInt(components[2]);
            this.stringValue = this.toSerializedForm();
            this.verify();
        }
        catch (ArrayIndexOutOfBoundsException | AssertionError | IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid version specification: \"%s\": %s", versionString, ((Throwable)e).getMessage()));
        }
    }

    private void verify() {
        if (this.major < 0) {
            throw new IllegalArgumentException("Negative major value");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("Negative minor value");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("Negative micro value");
        }
    }

    public String toSerializedForm() {
        return String.format("%d.%d.%d", this.major, this.minor, this.micro);
    }

    public static Version fromIntValues(int major, int minor, int micro) {
        return new Version(major, minor, micro);
    }

    public static Version fromString(String versionString) {
        return new Version(versionString);
    }

    public String toString() {
        return this.stringValue;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro;
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int comparison = Integer.compare(this.getMajor(), other.getMajor());
        if (comparison != 0) {
            return comparison;
        }
        comparison = Integer.compare(this.getMinor(), other.getMinor());
        if (comparison != 0) {
            return comparison;
        }
        return Integer.compare(this.getMicro(), other.getMicro());
    }
}

