/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provisioning;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class FlavorsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "13be801fd83bba0b7763f57485f71b24";
    public static final String CONFIG_DEF_NAME = "flavors";
    public static final String CONFIG_DEF_NAMESPACE = "config.provisioning";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=config.provisioning", "flavor[].name string", "flavor[].replaces[].name string", "flavor[].cost int default=0", "flavor[].stock bool default=true", "flavor[].environment string default=\"undefined\"", "flavor[].minCpuCores double default=0.0", "flavor[].minMainMemoryAvailableGb double default=0.0", "flavor[].minDiskAvailableGb double default=0.0", "flavor[].fastDisk bool default=true", "flavor[].description string default=\"\"", "flavor[].retired bool default=false", "flavor[].idealHeadroom int default=0"};
    private final InnerNodeVector<Flavor> flavor;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public FlavorsConfig(Builder builder) {
        this(builder, true);
    }

    private FlavorsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for flavors must be initialized: " + builder.__uninitialized);
        }
        this.flavor = Flavor.createVector(builder.flavor);
    }

    public List<Flavor> flavor() {
        return this.flavor;
    }

    public Flavor flavor(int i) {
        return (Flavor)((Object)this.flavor.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FlavorsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Flavor
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Replaces> replaces;
        private final IntegerNode cost;
        private final BooleanNode stock;
        private final StringNode environment;
        private final DoubleNode minCpuCores;
        private final DoubleNode minMainMemoryAvailableGb;
        private final DoubleNode minDiskAvailableGb;
        private final BooleanNode fastDisk;
        private final StringNode description;
        private final BooleanNode retired;
        private final IntegerNode idealHeadroom;

        @Deprecated
        private Flavor() {
            this(new Builder(), false);
        }

        public Flavor(Builder builder) {
            this(builder, true);
        }

        private Flavor(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for flavors.flavor[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.replaces = Replaces.createVector(builder.replaces);
            this.cost = builder.cost == null ? new IntegerNode(0) : new IntegerNode(builder.cost.intValue());
            this.stock = builder.stock == null ? new BooleanNode(true) : new BooleanNode(builder.stock.booleanValue());
            this.environment = builder.environment == null ? new StringNode("undefined") : new StringNode(builder.environment);
            this.minCpuCores = builder.minCpuCores == null ? new DoubleNode(0.0) : new DoubleNode(builder.minCpuCores.doubleValue());
            this.minMainMemoryAvailableGb = builder.minMainMemoryAvailableGb == null ? new DoubleNode(0.0) : new DoubleNode(builder.minMainMemoryAvailableGb.doubleValue());
            this.minDiskAvailableGb = builder.minDiskAvailableGb == null ? new DoubleNode(0.0) : new DoubleNode(builder.minDiskAvailableGb.doubleValue());
            this.fastDisk = builder.fastDisk == null ? new BooleanNode(true) : new BooleanNode(builder.fastDisk.booleanValue());
            this.description = builder.description == null ? new StringNode(FlavorsConfig.CONFIG_DEF_VERSION) : new StringNode(builder.description);
            this.retired = builder.retired == null ? new BooleanNode(false) : new BooleanNode(builder.retired.booleanValue());
            this.idealHeadroom = builder.idealHeadroom == null ? new IntegerNode(0) : new IntegerNode(builder.idealHeadroom.intValue());
        }

        public String name() {
            return this.name.value();
        }

        public List<Replaces> replaces() {
            return this.replaces;
        }

        public Replaces replaces(int i) {
            return (Replaces)((Object)this.replaces.get(i));
        }

        public int cost() {
            return this.cost.value();
        }

        public boolean stock() {
            return this.stock.value();
        }

        public String environment() {
            return this.environment.value();
        }

        public double minCpuCores() {
            return this.minCpuCores.value();
        }

        public double minMainMemoryAvailableGb() {
            return this.minMainMemoryAvailableGb.value();
        }

        public double minDiskAvailableGb() {
            return this.minDiskAvailableGb.value();
        }

        public boolean fastDisk() {
            return this.fastDisk.value();
        }

        public String description() {
            return this.description.value();
        }

        public boolean retired() {
            return this.retired.value();
        }

        public int idealHeadroom() {
            return this.idealHeadroom.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Flavor newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("flavor");
            return changes;
        }

        private static InnerNodeVector<Flavor> createVector(List<Builder> builders) {
            ArrayList<Flavor> elems = new ArrayList<Flavor>();
            for (Builder b : builders) {
                elems.add(new Flavor(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Flavor());
        }

        public static final class Replaces
        extends InnerNode {
            private final StringNode name;

            @Deprecated
            private Replaces() {
                this(new Builder(), false);
            }

            public Replaces(Builder builder) {
                this(builder, true);
            }

            private Replaces(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for flavors.flavor[].replaces[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            }

            public String name() {
                return this.name.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Replaces newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("replaces");
                return changes;
            }

            private static InnerNodeVector<Replaces> createVector(List<Builder> builders) {
                ArrayList<Replaces> elems = new ArrayList<Replaces>();
                for (Builder b : builders) {
                    elems.add(new Replaces(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Replaces());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                private String name = null;

                public Builder() {
                }

                public Builder(Replaces config) {
                    this.name(config.name());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<Replaces.Builder> replaces = new ArrayList<Replaces.Builder>();
            private Integer cost = null;
            private Boolean stock = null;
            private String environment = null;
            private Double minCpuCores = null;
            private Double minMainMemoryAvailableGb = null;
            private Double minDiskAvailableGb = null;
            private Boolean fastDisk = null;
            private String description = null;
            private Boolean retired = null;
            private Integer idealHeadroom = null;

            public Builder() {
            }

            public Builder(Flavor config) {
                this.name(config.name());
                for (Replaces r : config.replaces()) {
                    this.replaces(new Replaces.Builder(r));
                }
                this.cost(config.cost());
                this.stock(config.stock());
                this.environment(config.environment());
                this.minCpuCores(config.minCpuCores());
                this.minMainMemoryAvailableGb(config.minMainMemoryAvailableGb());
                this.minDiskAvailableGb(config.minDiskAvailableGb());
                this.fastDisk(config.fastDisk());
                this.description(config.description());
                this.retired(config.retired());
                this.idealHeadroom(config.idealHeadroom());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.replaces.isEmpty()) {
                    this.replaces.addAll(__superior.replaces);
                }
                if (__superior.cost != null) {
                    this.cost(__superior.cost);
                }
                if (__superior.stock != null) {
                    this.stock(__superior.stock);
                }
                if (__superior.environment != null) {
                    this.environment(__superior.environment);
                }
                if (__superior.minCpuCores != null) {
                    this.minCpuCores(__superior.minCpuCores);
                }
                if (__superior.minMainMemoryAvailableGb != null) {
                    this.minMainMemoryAvailableGb(__superior.minMainMemoryAvailableGb);
                }
                if (__superior.minDiskAvailableGb != null) {
                    this.minDiskAvailableGb(__superior.minDiskAvailableGb);
                }
                if (__superior.fastDisk != null) {
                    this.fastDisk(__superior.fastDisk);
                }
                if (__superior.description != null) {
                    this.description(__superior.description);
                }
                if (__superior.retired != null) {
                    this.retired(__superior.retired);
                }
                if (__superior.idealHeadroom != null) {
                    this.idealHeadroom(__superior.idealHeadroom);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder replaces(Replaces.Builder __builder) {
                this.replaces.add(__builder);
                return this;
            }

            public Builder replaces(List<Replaces.Builder> __builders) {
                this.replaces = __builders;
                return this;
            }

            public Builder cost(int __value) {
                this.cost = __value;
                return this;
            }

            private Builder cost(String __value) {
                return this.cost(Integer.valueOf(__value));
            }

            public Builder stock(boolean __value) {
                this.stock = __value;
                return this;
            }

            private Builder stock(String __value) {
                return this.stock(Boolean.valueOf(__value));
            }

            public Builder environment(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.environment = __value;
                return this;
            }

            public Builder minCpuCores(double __value) {
                this.minCpuCores = __value;
                return this;
            }

            private Builder minCpuCores(String __value) {
                return this.minCpuCores(Double.valueOf(__value));
            }

            public Builder minMainMemoryAvailableGb(double __value) {
                this.minMainMemoryAvailableGb = __value;
                return this;
            }

            private Builder minMainMemoryAvailableGb(String __value) {
                return this.minMainMemoryAvailableGb(Double.valueOf(__value));
            }

            public Builder minDiskAvailableGb(double __value) {
                this.minDiskAvailableGb = __value;
                return this;
            }

            private Builder minDiskAvailableGb(String __value) {
                return this.minDiskAvailableGb(Double.valueOf(__value));
            }

            public Builder fastDisk(boolean __value) {
                this.fastDisk = __value;
                return this;
            }

            private Builder fastDisk(String __value) {
                return this.fastDisk(Boolean.valueOf(__value));
            }

            public Builder description(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.description = __value;
                return this;
            }

            public Builder retired(boolean __value) {
                this.retired = __value;
                return this;
            }

            private Builder retired(String __value) {
                return this.retired(Boolean.valueOf(__value));
            }

            public Builder idealHeadroom(int __value) {
                this.idealHeadroom = __value;
                return this;
            }

            private Builder idealHeadroom(String __value) {
                return this.idealHeadroom(Integer.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Flavor.Builder> flavor = new ArrayList<Flavor.Builder>();

        public Builder() {
        }

        public Builder(FlavorsConfig config) {
            for (Flavor f : config.flavor()) {
                this.flavor(new Flavor.Builder(f));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.flavor.isEmpty()) {
                this.flavor.addAll(__superior.flavor);
            }
            return this;
        }

        public Builder flavor(Flavor.Builder __builder) {
            this.flavor.add(__builder);
            return this;
        }

        public Builder flavor(List<Flavor.Builder> __builders) {
            this.flavor = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return FlavorsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return FlavorsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return FlavorsConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

