/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import java.util.Objects;

public class ZoneId {
    private final Environment environment;
    private final RegionName region;

    private ZoneId(Environment environment, RegionName region) {
        this.environment = Objects.requireNonNull(environment);
        this.region = Objects.requireNonNull(region);
    }

    public static ZoneId from(Environment environment, RegionName region) {
        return new ZoneId(environment, region);
    }

    public static ZoneId from(String environment, String region) {
        return ZoneId.from(Environment.from(environment), RegionName.from(region));
    }

    public static ZoneId from(String value) {
        String[] parts = value.split("\\.");
        return ZoneId.from(parts[0], parts[1]);
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public String value() {
        return (Object)((Object)this.environment) + "." + this.region;
    }

    public String toString() {
        return "zone " + this.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZoneId)) {
            return false;
        }
        ZoneId id = (ZoneId)o;
        return this.environment == id.environment && Objects.equals(this.region, id.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }
}

