/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;

public class DockerImage {
    private final String name;

    public DockerImage(String name) {
        this.name = name;
    }

    public Version tagAsVersion() {
        String[] parts = this.asString().split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Could not parse tag from Docker image '" + this.asString() + "'");
        }
        return Version.fromString((String)parts[parts.length - 1]);
    }

    public DockerImage withTag(Version version) {
        return new DockerImage(this.name + ":" + version.toFullString());
    }

    public String asString() {
        return this.name;
    }
}

