/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import java.util.Objects;
import java.util.Optional;

public final class ClusterSpec {
    private final Type type;
    private final Id id;
    private final Optional<Group> groupId;
    private final Version vespaVersion;

    private ClusterSpec(Type type, Id id, Optional<Group> groupId, Version vespaVersion) {
        this.type = type;
        this.id = id;
        this.groupId = groupId;
        this.vespaVersion = vespaVersion;
    }

    public Type type() {
        return this.type;
    }

    public Id id() {
        return this.id;
    }

    public Version vespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Group> group() {
        return this.groupId;
    }

    public ClusterSpec changeGroup(Optional<Group> newGroup) {
        return new ClusterSpec(this.type, this.id, newGroup, this.vespaVersion);
    }

    public static ClusterSpec request(Type type, Id id, Version vespaVersion) {
        return new ClusterSpec(type, id, Optional.empty(), vespaVersion);
    }

    public static ClusterSpec from(Type type, Id id, Group groupId, Version vespaVersion) {
        return new ClusterSpec(type, id, Optional.of(groupId), vespaVersion);
    }

    public String toString() {
        return String.join((CharSequence)" ", this.type.toString(), this.id.toString(), this.groupId.map(Group::toString).orElse(""), this.vespaVersion.toString());
    }

    public int hashCode() {
        return this.type.hashCode() + 17 * this.id.hashCode() + 31 * this.groupId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterSpec)) {
            return false;
        }
        ClusterSpec other = (ClusterSpec)o;
        if (!other.type.equals((Object)this.type)) {
            return false;
        }
        if (!other.id.equals(this.id)) {
            return false;
        }
        if (!other.groupId.equals(this.groupId)) {
            return false;
        }
        return other.vespaVersion.equals((Object)this.vespaVersion);
    }

    public boolean equalsIgnoringGroupAndVespaVersion(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterSpec)) {
            return false;
        }
        ClusterSpec other = (ClusterSpec)o;
        if (!other.type.equals((Object)this.type)) {
            return false;
        }
        return other.id.equals(this.id);
    }

    public static final class Group {
        private final int index;

        private Group(int index) {
            this.index = index;
        }

        public static Group from(int index) {
            return new Group(index);
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return "group " + this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Group)o).index == this.index;
        }

        public int hashCode() {
            return this.index;
        }
    }

    public static final class Id {
        private final String id;

        public Id(String id) {
            Objects.requireNonNull(id, "Id cannot be null");
            this.id = id;
        }

        public static Id from(String id) {
            return new Id(id);
        }

        public String value() {
            return this.id;
        }

        public String toString() {
            return "cluster '" + this.id + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Id)o).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static enum Type {
        admin,
        container,
        content;


        public static Type from(String typeName) {
            switch (typeName) {
                case "admin": {
                    return admin;
                }
                case "container": {
                    return container;
                }
                case "content": {
                    return content;
                }
            }
            throw new IllegalArgumentException("Illegal cluster type '" + typeName + "'");
        }
    }
}

