/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.cloud.config.ApplicationIdConfig;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.TenantName;

public final class ApplicationId
implements Comparable<ApplicationId> {
    private final TenantName tenant;
    private final ApplicationName application;
    private final InstanceName instance;
    private final String stringValue;
    private final String serializedForm;

    public ApplicationId(ApplicationIdConfig config) {
        this(TenantName.from(config.tenant()), ApplicationName.from(config.application()), InstanceName.from(config.instance()));
    }

    private ApplicationId(TenantName tenant, ApplicationName applicationName, InstanceName instanceName) {
        this.tenant = tenant;
        this.application = applicationName;
        this.instance = instanceName;
        this.stringValue = this.toStringValue();
        this.serializedForm = this.toSerializedForm();
    }

    public static ApplicationId from(TenantName tenant, ApplicationName application, InstanceName instance) {
        return new ApplicationId(tenant, application, instance);
    }

    public static ApplicationId from(String tenant, String application, String instance) {
        return new ApplicationId(TenantName.from(tenant), ApplicationName.from(application), InstanceName.from(instance));
    }

    public static ApplicationId fromSerializedForm(String idString) {
        String[] parts = idString.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Application ids must be on the form tenant:application:instance, but was " + idString);
        }
        return new Builder().tenant(parts[0]).applicationName(parts[1]).instanceName(parts[2]).build();
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ApplicationId rhs = (ApplicationId)other;
        return this.tenant.equals(rhs.tenant) && this.application.equals(rhs.application) && this.instance.equals(rhs.instance);
    }

    public String serializedForm() {
        return this.serializedForm;
    }

    private String toStringValue() {
        return "tenant '" + this.tenant + "', application '" + this.application + "', instance '" + this.instance + "'";
    }

    public String toShortString() {
        return this.tenant().value() + "." + this.application().value() + (this.instance().isDefault() ? "" : "." + this.instance().value());
    }

    private String toSerializedForm() {
        return this.tenant + ":" + this.application + ":" + this.instance;
    }

    public String toString() {
        return this.toShortString();
    }

    public TenantName tenant() {
        return this.tenant;
    }

    public ApplicationName application() {
        return this.application;
    }

    public InstanceName instance() {
        return this.instance;
    }

    @Override
    public int compareTo(ApplicationId other) {
        int diff = this.tenant.compareTo(other.tenant);
        if (diff != 0) {
            return diff;
        }
        diff = this.application.compareTo(other.application);
        if (diff != 0) {
            return diff;
        }
        diff = this.instance.compareTo(other.instance);
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    public static ApplicationId defaultId() {
        return new ApplicationId(TenantName.defaultName(), ApplicationName.defaultName(), InstanceName.defaultName());
    }

    public static ApplicationId global() {
        return new Builder().tenant("*").applicationName("*").instanceName("*").build();
    }

    public static class Builder {
        private TenantName tenant = TenantName.defaultName();
        private ApplicationName application = null;
        private InstanceName instance = InstanceName.defaultName();

        public Builder tenant(TenantName ten) {
            this.tenant = ten;
            return this;
        }

        public Builder tenant(String ten) {
            return this.tenant(TenantName.from(ten));
        }

        public Builder applicationName(ApplicationName nam) {
            this.application = nam;
            return this;
        }

        public Builder applicationName(String nam) {
            return this.applicationName(ApplicationName.from(nam));
        }

        public Builder instanceName(InstanceName ins) {
            this.instance = ins;
            return this;
        }

        public Builder instanceName(String ins) {
            return this.instanceName(InstanceName.from(ins));
        }

        public ApplicationId build() {
            if (this.application == null) {
                throw new IllegalArgumentException("must set application name in builder");
            }
            return ApplicationId.from(this.tenant, this.application, this.instance);
        }
    }
}

