/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterSpec;

public class ClusterMembership {
    private ClusterSpec cluster;
    private int index;
    private boolean retired;
    private String stringValue;

    protected ClusterMembership() {
    }

    private ClusterMembership(String stringValue, Version vespaVersion) {
        String restValue;
        if (stringValue.endsWith("/retired")) {
            this.retired = true;
            restValue = stringValue.substring(0, stringValue.length() - "/retired".length());
        } else {
            this.retired = false;
            restValue = stringValue;
        }
        String[] components = restValue.split("/");
        if (components.length == 3) {
            this.initWithoutGroup(components, vespaVersion);
        } else if (components.length == 4) {
            this.initWithGroup(components, vespaVersion);
        } else {
            throw new RuntimeException("Could not parse '" + stringValue + "' to a cluster membership. Expected 'id/type.index[/group]'");
        }
        this.stringValue = this.toStringValue();
    }

    private ClusterMembership(ClusterSpec cluster, int index, boolean retired) {
        this.cluster = cluster;
        this.index = index;
        this.retired = retired;
        this.stringValue = this.toStringValue();
    }

    private void initWithoutGroup(String[] components, Version vespaVersion) {
        this.cluster = ClusterSpec.request(ClusterSpec.Type.valueOf(components[0]), ClusterSpec.Id.from(components[1]), vespaVersion);
        this.index = Integer.parseInt(components[2]);
    }

    private void initWithGroup(String[] components, Version vespaVersion) {
        this.cluster = ClusterSpec.from(ClusterSpec.Type.valueOf(components[0]), ClusterSpec.Id.from(components[1]), ClusterSpec.Group.from(Integer.valueOf(components[2])), vespaVersion);
        this.index = Integer.parseInt(components[3]);
    }

    protected String toStringValue() {
        return this.cluster.type().name() + "/" + this.cluster.id().value() + (this.cluster.group().isPresent() ? "/" + this.cluster.group().get().index() : "") + "/" + this.index + (this.retired ? "/retired" : "");
    }

    public ClusterSpec cluster() {
        return this.cluster;
    }

    public int index() {
        return this.index;
    }

    public boolean retired() {
        return this.retired;
    }

    public ClusterMembership retire() {
        return new ClusterMembership(this.cluster, this.index, true);
    }

    public ClusterMembership unretire() {
        return new ClusterMembership(this.cluster, this.index, false);
    }

    public ClusterMembership changeCluster(ClusterSpec newCluster) {
        return new ClusterMembership(newCluster, this.index, this.retired);
    }

    public String stringValue() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.stringValue().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClusterMembership)) {
            return false;
        }
        return ((ClusterMembership)other).stringValue().equals(this.stringValue());
    }

    public String toString() {
        return this.stringValue();
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion) {
        return new ClusterMembership(stringValue, vespaVersion);
    }

    public static ClusterMembership from(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, false);
    }

    public static ClusterMembership retiredFrom(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, true);
    }
}

