/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.ArrayList;
import java.util.List;

public class Flavor {
    private final String name;
    private final int cost;
    private final boolean isStock;
    private final Type type;
    private final double minCpuCores;
    private final double minMainMemoryAvailableGb;
    private final double minDiskAvailableGb;
    private final boolean fastDisk;
    private final String description;
    private final boolean retired;
    private List<Flavor> replacesFlavors;
    private int idealHeadroom;

    public Flavor(FlavorsConfig.Flavor flavorConfig) {
        this.name = flavorConfig.name();
        this.replacesFlavors = new ArrayList<Flavor>();
        this.cost = flavorConfig.cost();
        this.isStock = flavorConfig.stock();
        this.type = Type.valueOf(flavorConfig.environment());
        this.minCpuCores = flavorConfig.minCpuCores();
        this.minMainMemoryAvailableGb = flavorConfig.minMainMemoryAvailableGb();
        this.minDiskAvailableGb = flavorConfig.minDiskAvailableGb();
        this.fastDisk = flavorConfig.fastDisk();
        this.description = flavorConfig.description();
        this.retired = flavorConfig.retired();
        this.idealHeadroom = flavorConfig.idealHeadroom();
    }

    public String name() {
        return this.name;
    }

    public int cost() {
        return this.cost;
    }

    public boolean isStock() {
        return this.isStock;
    }

    public double getMinMainMemoryAvailableGb() {
        return this.minMainMemoryAvailableGb;
    }

    public double getMinDiskAvailableGb() {
        return this.minDiskAvailableGb;
    }

    public boolean hasFastDisk() {
        return this.fastDisk;
    }

    public double getMinCpuCores() {
        return this.minCpuCores;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public Type getType() {
        return this.type;
    }

    public int getIdealHeadroom() {
        return this.idealHeadroom;
    }

    public String canonicalName() {
        return this.isCanonical() ? this.name : this.replacesFlavors.get(0).canonicalName();
    }

    public boolean isCanonical() {
        return this.replacesFlavors.size() != 1;
    }

    public List<Flavor> replaces() {
        return this.replacesFlavors;
    }

    public boolean satisfies(Flavor flavor) {
        if (this.equals(flavor)) {
            return true;
        }
        if (this.retired) {
            return false;
        }
        for (Flavor replaces : this.replacesFlavors) {
            if (!replaces.satisfies(flavor)) continue;
            return true;
        }
        return false;
    }

    public void freeze() {
        this.replacesFlavors = ImmutableList.copyOf(this.replacesFlavors);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Flavor)) {
            return false;
        }
        return ((Flavor)other).name.equals(this.name);
    }

    public String toString() {
        return "flavor '" + this.name + "'";
    }

    public static enum Type {
        undefined,
        BARE_METAL,
        VIRTUAL_MACHINE,
        DOCKER_CONTAINER;

    }
}

