/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.utils;

import com.yahoo.config.FileReference;
import com.yahoo.config.ModelReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.model.AbstractService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class FileSender
implements Serializable {
    private final Collection<? extends AbstractService> services;
    private final FileRegistry fileRegistry;
    private final DeployLogger logger;

    public FileSender(Collection<? extends AbstractService> services, FileRegistry fileRegistry, DeployLogger logger) {
        this.services = services;
        this.fileRegistry = fileRegistry;
        this.logger = logger;
    }

    public <PRODUCER extends AbstractConfigProducer<?>> void sendUserConfiguredFiles(PRODUCER producer) {
        if (this.services.isEmpty()) {
            return;
        }
        UserConfigRepo userConfigs = producer.getUserConfigs();
        HashMap<Path, FileReference> sentFiles = new HashMap<Path, FileReference>();
        for (ConfigDefinitionKey key : userConfigs.configsProduced()) {
            ConfigPayloadBuilder builder = userConfigs.get(key);
            try {
                this.sendUserConfiguredFiles(builder, sentFiles, key);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unable to send file specified in " + key, e);
            }
        }
    }

    private void sendUserConfiguredFiles(ConfigPayloadBuilder builder, Map<Path, FileReference> sentFiles, ConfigDefinitionKey key) {
        ConfigPayloadBuilder.MapBuilder map;
        ConfigPayloadBuilder.Array array;
        ConfigDefinition configDefinition = builder.getConfigDefinition();
        if (configDefinition == null) {
            this.logger.logApplicationPackage(Level.FINE, "Not able to find config definition for " + key + ". Will not send files for this config");
            return;
        }
        this.sendEntries(builder, sentFiles, configDefinition.getFileDefs(), false);
        this.sendEntries(builder, sentFiles, configDefinition.getPathDefs(), false);
        this.sendEntries(builder, sentFiles, configDefinition.getModelDefs(), true);
        for (Map.Entry entry : configDefinition.getArrayDefs().entrySet()) {
            if (!FileSender.isAnyFileType(((ConfigDefinition.ArrayDef)entry.getValue()).getTypeSpec().getType())) continue;
            array = builder.getArray((String)entry.getKey());
            this.sendFileEntries(array.getElements(), sentFiles, "model".equals(((ConfigDefinition.ArrayDef)entry.getValue()).getTypeSpec().getType()));
        }
        for (Map.Entry entry : configDefinition.getLeafMapDefs().entrySet()) {
            if (!FileSender.isAnyFileType(((ConfigDefinition.LeafMapDef)entry.getValue()).getTypeSpec().getType())) continue;
            map = builder.getMap((String)entry.getKey());
            this.sendFileEntries(map.getElements(), sentFiles, "model".equals(((ConfigDefinition.LeafMapDef)entry.getValue()).getTypeSpec().getType()));
        }
        for (String name : configDefinition.getStructDefs().keySet()) {
            this.sendUserConfiguredFiles(builder.getObject(name), sentFiles, key);
        }
        for (String name : configDefinition.getInnerArrayDefs().keySet()) {
            array = builder.getArray(name);
            for (ConfigPayloadBuilder element : array.getElements()) {
                this.sendUserConfiguredFiles(element, sentFiles, key);
            }
        }
        for (String name : configDefinition.getStructMapDefs().keySet()) {
            map = builder.getMap(name);
            for (ConfigPayloadBuilder element : map.getElements()) {
                this.sendUserConfiguredFiles(element, sentFiles, key);
            }
        }
    }

    private static boolean isAnyFileType(String type) {
        return "file".equals(type) || "path".equals(type) || "model".equals(type);
    }

    private void sendEntries(ConfigPayloadBuilder builder, Map<Path, FileReference> sentFiles, Map<String, ?> entries, boolean isModelType) {
        for (String name : entries.keySet()) {
            ConfigPayloadBuilder fileEntry = builder.getObject(name);
            if (fileEntry.getValue() == null) {
                throw new IllegalArgumentException("Unable to send file for field '" + name + "': Invalid config value " + fileEntry.getValue());
            }
            this.sendFileEntry(fileEntry, sentFiles, isModelType);
        }
    }

    private void sendFileEntries(Collection<ConfigPayloadBuilder> builders, Map<Path, FileReference> sentFiles, boolean isModelType) {
        for (ConfigPayloadBuilder builder : builders) {
            this.sendFileEntry(builder, sentFiles, isModelType);
        }
    }

    private void sendFileEntry(ConfigPayloadBuilder builder, Map<Path, FileReference> sentFiles, boolean isModelType) {
        Path path;
        if (isModelType) {
            ModelReference modelReference = ModelReference.valueOf((String)builder.getValue());
            if (modelReference.path().isEmpty()) {
                return;
            }
            path = Path.fromString((String)((FileReference)modelReference.path().get()).value());
        } else {
            path = Path.fromString((String)builder.getValue());
        }
        FileReference reference = sentFiles.get(path);
        if (reference == null) {
            reference = this.fileRegistry.addFile(path.getRelative());
            sentFiles.put(path, reference);
        }
        if (isModelType) {
            ModelReference model = ModelReference.valueOf((String)builder.getValue());
            ModelReference modelWithReference = ModelReference.unresolved((Optional)model.modelId(), (Optional)model.url(), Optional.of(reference));
            builder.setValue(modelWithReference.toString());
        } else {
            builder.setValue(reference.value());
        }
    }
}

