/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.admin.AdminModel;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.IndexingDocprocChain;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class Content
extends ConfigModel {
    private static final String DOCPROC_RESERVED_NAME = "docproc";
    private ContentCluster cluster;
    private Optional<ApplicationContainerCluster> ownedIndexingCluster = Optional.empty();
    private final AdminModel adminModel;
    private final Collection<ContainerModel> containers;

    public Content(ConfigModelContext modelContext, AdminModel adminModel, Collection<ContainerModel> containers) {
        super(modelContext);
        modelContext.getParentProducer().getRoot();
        this.adminModel = adminModel;
        this.containers = containers;
    }

    public ContentCluster getCluster() {
        return this.cluster;
    }

    public Optional<ApplicationContainerCluster> ownedIndexingCluster() {
        return this.ownedIndexingCluster;
    }

    private static boolean containsIndexingChain(ComponentRegistry<DocprocChain> allChains, ChainSpecification chainSpec) {
        if ("indexing".equals(chainSpec.componentId.stringValue())) {
            return true;
        }
        ChainSpecification.Inheritance inheritance = chainSpec.inheritance;
        for (ComponentSpecification parentComponentSpec : inheritance.chainSpecifications) {
            ChainSpecification parentSpec = Content.getChainSpec(allChains, parentComponentSpec);
            if (!Content.containsIndexingChain(allChains, parentSpec)) continue;
            return true;
        }
        return false;
    }

    private static ChainSpecification getChainSpec(ComponentRegistry<DocprocChain> allChains, ComponentSpecification componentSpec) {
        DocprocChain docprocChain = (DocprocChain)allChains.getComponent(componentSpec);
        if (docprocChain == null) {
            throw new IllegalArgumentException("Chain '" + componentSpec + "' not found.");
        }
        return docprocChain.getChainSpecification();
    }

    private static void addIndexingChain(ContainerCluster<?> containerCluster) {
        DocprocChain chainAlreadyPresent = (DocprocChain)containerCluster.getDocprocChains().allChains().getComponent(new ComponentId("indexing"));
        if (chainAlreadyPresent != null) {
            if (chainAlreadyPresent instanceof IndexingDocprocChain) {
                return;
            }
            throw new IllegalArgumentException("A docproc chain may not have the ID 'indexing, since this is reserved by Vespa. Please use a different ID.");
        }
        containerCluster.getDocprocChains().add(new IndexingDocprocChain());
    }

    private static ContainerCluster<?> getContainerWithSearch(Collection<ContainerModel> containers) {
        for (ContainerModel container : containers) {
            if (container.getCluster().getSearch() == null) continue;
            return container.getCluster();
        }
        return null;
    }

    private static void checkThatExplicitIndexingChainInheritsCorrectly(ComponentRegistry<DocprocChain> allChains, ChainSpecification chainSpec) {
        ChainSpecification.Inheritance inheritance = chainSpec.inheritance;
        for (ComponentSpecification componentSpec : inheritance.chainSpecifications) {
            ChainSpecification parentSpec = Content.getChainSpec(allChains, componentSpec);
            if (!Content.containsIndexingChain(allChains, parentSpec)) continue;
            return;
        }
        throw new IllegalArgumentException("Docproc chain '" + chainSpec.componentId + "' must inherit from the 'indexing' chain");
    }

    public static List<Content> getContent(ConfigModelRepo pc) {
        ArrayList<Content> contents = new ArrayList<Content>();
        for (ConfigModel model : pc.asMap().values()) {
            if (!(model instanceof Content)) continue;
            contents.add((Content)model);
        }
        return contents;
    }

    public static List<SearchCluster> getSearchClusters(ConfigModelRepo pc) {
        ArrayList<SearchCluster> clusters = new ArrayList<SearchCluster>();
        for (ContentCluster c : Content.getContentClusters(pc)) {
            clusters.addAll(c.getSearch().getClusters().values());
        }
        return clusters;
    }

    public static List<ContentCluster> getContentClusters(ConfigModelRepo pc) {
        ArrayList<ContentCluster> clusters = new ArrayList<ContentCluster>();
        for (Content c : Content.getContent(pc)) {
            clusters.add(c.getCluster());
        }
        return clusters;
    }

    @Override
    public void prepare(ConfigModelRepo models, DeployState deployState) {
        if (this.cluster.getRootGroup().useCpuSocketAffinity()) {
            this.setCpuSocketAffinity();
        }
        if (this.cluster.getRootGroup().getMmapNoCoreLimit().isPresent()) {
            for (AbstractService abstractService : this.cluster.getSearch().getSearchNodes()) {
                abstractService.setMMapNoCoreLimit(this.cluster.getRootGroup().getMmapNoCoreLimit().get());
            }
        }
        if (this.cluster.getRootGroup().getCoreOnOOM().isPresent()) {
            for (AbstractService abstractService : this.cluster.getSearch().getSearchNodes()) {
                abstractService.setCoreOnOOM(this.cluster.getRootGroup().getCoreOnOOM().get());
            }
        }
        if (this.cluster.getRootGroup().getNoVespaMalloc().isPresent()) {
            for (AbstractService abstractService : this.cluster.getSearch().getSearchNodes()) {
                abstractService.setNoVespaMalloc(this.cluster.getRootGroup().getNoVespaMalloc().get());
            }
        }
        if (this.cluster.getRootGroup().getVespaMalloc().isPresent()) {
            for (AbstractService abstractService : this.cluster.getSearch().getSearchNodes()) {
                abstractService.setVespaMalloc(this.cluster.getRootGroup().getVespaMalloc().get());
            }
        }
        if (this.cluster.getRootGroup().getVespaMallocDebug().isPresent()) {
            for (AbstractService abstractService : this.cluster.getSearch().getSearchNodes()) {
                abstractService.setVespaMallocDebug(this.cluster.getRootGroup().getVespaMallocDebug().get());
            }
        }
        if (this.cluster.getRootGroup().getVespaMallocDebugStackTrace().isPresent()) {
            for (AbstractService abstractService : this.cluster.getSearch().getSearchNodes()) {
                abstractService.setVespaMallocDebugStackTrace(this.cluster.getRootGroup().getVespaMallocDebugStackTrace().get());
            }
        }
    }

    private void setCpuSocketAffinity() {
        AbstractService.distributeCpuSocketAffinity(this.cluster.getSearch().getSearchNodes());
    }

    public static class Builder
    extends ConfigModelBuilder<Content> {
        public static final List<ConfigModelId> configModelIds = Collections.singletonList(ConfigModelId.fromName("content"));

        public Builder() {
            super(Content.class);
        }

        @Override
        public List<ConfigModelId> handlesElements() {
            return configModelIds;
        }

        @Override
        public void doBuild(Content content, Element xml, ConfigModelContext modelContext) {
            Admin admin = content.adminModel != null ? content.adminModel.getAdmin() : null;
            content.cluster = new ContentCluster.Builder(admin).build(content.containers, modelContext, xml);
            this.buildIndexingClusters(content, modelContext, (ApplicationConfigProducerRoot)modelContext.getParentProducer());
        }

        private void buildIndexingClusters(Content content, ConfigModelContext modelContext, ApplicationConfigProducerRoot root) {
            if (!content.getCluster().getSearch().hasIndexedCluster()) {
                return;
            }
            IndexedSearchCluster indexedSearchCluster = content.getCluster().getSearch().getIndexed();
            if (indexedSearchCluster.hasExplicitIndexingCluster()) {
                this.setExistingIndexingCluster(indexedSearchCluster, content.containers);
            } else {
                this.setContainerAsIndexingCluster(indexedSearchCluster, content, modelContext, root);
            }
        }

        private void setContainerAsIndexingCluster(IndexedSearchCluster indexedSearchCluster, Content content, ConfigModelContext modelContext, ApplicationConfigProducerRoot root) {
            if (content.containers.isEmpty()) {
                this.createImplicitIndexingCluster(indexedSearchCluster, content, modelContext, root);
            } else {
                ContainerCluster<Object> targetCluster = this.getContainerWithDocproc(content.containers);
                if (targetCluster == null) {
                    targetCluster = Content.getContainerWithSearch(content.containers);
                }
                if (targetCluster == null) {
                    targetCluster = content.containers.iterator().next().getCluster();
                }
                this.addDocproc(targetCluster);
                indexedSearchCluster.setIndexingClusterName(targetCluster.getName());
                this.addIndexingChainsTo(targetCluster, indexedSearchCluster);
            }
        }

        private void setExistingIndexingCluster(IndexedSearchCluster cluster, Collection<ContainerModel> containers) {
            String indexingClusterName = cluster.getIndexingClusterName();
            ContainerModel containerModel = this.findByName(indexingClusterName, containers);
            if (containerModel == null) {
                throw new IllegalArgumentException("Content cluster '" + cluster.getClusterName() + "' refers to docproc cluster '" + indexingClusterName + "', but this cluster does not exist.");
            }
            this.addIndexingChainsTo(containerModel.getCluster(), cluster);
        }

        private ContainerModel findByName(String name, Collection<ContainerModel> containers) {
            for (ContainerModel container : containers) {
                if (!container.getId().equals(name)) continue;
                return container;
            }
            return null;
        }

        private void addIndexingChainsTo(ContainerCluster<?> indexer, IndexedSearchCluster cluster) {
            DocprocChain indexingChain;
            Content.addIndexingChain(indexer);
            ComponentRegistry allChains = indexer.getDocprocChains().allChains();
            if (cluster.hasExplicitIndexingChain()) {
                indexingChain = (DocprocChain)allChains.getComponent(cluster.getIndexingChainName());
                if (indexingChain == null) {
                    throw new IllegalArgumentException(cluster + " refers to docproc chain '" + cluster.getIndexingChainName() + "' for indexing, but this chain does not exist");
                }
                if (indexingChain.getId().getName().equals("default")) {
                    throw new IllegalArgumentException(cluster + " specifies the chain 'default' as indexing chain. As the 'default' chain is run by default, using it as the indexing chain will run it twice. Use a different name for the indexing chain.");
                }
                Content.checkThatExplicitIndexingChainInheritsCorrectly(allChains, indexingChain.getChainSpecification());
            } else {
                indexingChain = (DocprocChain)allChains.getComponent("indexing");
            }
            cluster.setIndexingChain(indexingChain);
        }

        private void createImplicitIndexingCluster(IndexedSearchCluster cluster, Content content, ConfigModelContext modelContext, ApplicationConfigProducerRoot root) {
            String indexerName = cluster.getIndexingClusterName();
            SimpleConfigProducer parent = (SimpleConfigProducer)root.getChildren().get(Content.DOCPROC_RESERVED_NAME);
            if (parent == null) {
                parent = new SimpleConfigProducer(root, Content.DOCPROC_RESERVED_NAME);
            }
            ApplicationContainerCluster indexingCluster = new ApplicationContainerCluster(parent, "cluster." + indexerName, indexerName, modelContext.getDeployState());
            ContainerModel indexingClusterModel = new ContainerModel(modelContext.withParent(parent).withId(indexingCluster.getSubId()));
            indexingClusterModel.setCluster(indexingCluster);
            modelContext.getConfigModelRepoAdder().add(indexingClusterModel);
            content.ownedIndexingCluster = Optional.of(indexingCluster);
            indexingCluster.addDefaultHandlersWithVip();
            indexingCluster.addAllPlatformBundles();
            this.addDocproc(indexingCluster);
            ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
            int index = 0;
            LinkedHashSet<HostResource> processedHosts = new LinkedHashSet<HostResource>();
            for (SearchNode searchNode : cluster.getSearchNodes()) {
                HostResource host = searchNode.getHostResource();
                if (processedHosts.contains(host)) continue;
                String containerName = String.valueOf(searchNode.getDistributionKey());
                ApplicationContainer docprocService = new ApplicationContainer(indexingCluster, containerName, index, modelContext.getDeployState());
                ++index;
                docprocService.useDynamicPorts();
                docprocService.setHostResource(host);
                docprocService.initService(modelContext.getDeployState());
                nodes.add(docprocService);
                processedHosts.add(host);
            }
            indexingCluster.addContainers(nodes);
            Content.addIndexingChain(indexingCluster);
            cluster.setIndexingChain((DocprocChain)indexingCluster.getDocprocChains().allChains().getComponent("indexing"));
        }

        private ContainerCluster<?> getContainerWithDocproc(Collection<ContainerModel> containers) {
            for (ContainerModel container : containers) {
                if (container.getCluster().getDocproc() == null) continue;
                return container.getCluster();
            }
            return null;
        }

        private void addDocproc(ContainerCluster<?> cluster) {
            if (cluster.getDocproc() == null) {
                DocprocChains chains = new DocprocChains(cluster, "docprocchains");
                ContainerDocproc containerDocproc = new ContainerDocproc(cluster, chains);
                cluster.setDocproc(containerDocproc);
            }
        }
    }
}

