/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.LogserverContainer;
import com.yahoo.vespa.model.admin.LogserverContainerCluster;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminBuilderBase;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.container.ContainerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DomAdminV4Builder
extends DomAdminBuilderBase {
    private final Collection<ContainerModel> containerModels;
    private final ConfigModelContext context;

    public DomAdminV4Builder(ConfigModelContext context, boolean multitenant, List<ConfigServerSpec> configServerSpecs, Collection<ContainerModel> containerModels) {
        super(context.getApplicationType(), multitenant, configServerSpecs);
        this.containerModels = containerModels;
        this.context = context;
    }

    @Override
    protected void doBuildAdmin(DeployState deployState, Admin admin, Element w3cAdminElement) {
        ModelElement adminElement = new ModelElement(w3cAdminElement);
        admin.addConfigservers(this.getConfigServersFromSpec(deployState, admin));
        Optional<NodesSpecification> requestedSlobroks = NodesSpecification.optionalDedicatedFromParent(adminElement.child("slobroks"), this.context);
        Optional<NodesSpecification> requestedLogservers = NodesSpecification.optionalDedicatedFromParent(adminElement.child("logservers"), this.context);
        this.assignSlobroks(deployState, requestedSlobroks.orElse(NodesSpecification.nonDedicated(3, this.context)), admin);
        this.assignLogserver(deployState, requestedLogservers.orElse(this.createNodesSpecificationForLogserver()), admin);
        this.addLogForwarders(adminElement.child("logforwarding"), admin);
        this.addLoggingSpecs(adminElement.child("logging"), admin);
    }

    private void assignSlobroks(DeployState deployState, NodesSpecification nodesSpecification, Admin admin) {
        if (nodesSpecification.isDedicated()) {
            this.createSlobroks(deployState, admin, this.allocateHosts(admin.hostSystem(), "slobroks", nodesSpecification));
        } else {
            this.createSlobroks(deployState, admin, this.pickContainerHostsForSlobrok(nodesSpecification.minResources().nodes(), 2));
        }
    }

    private void assignLogserver(DeployState deployState, NodesSpecification nodesSpecification, Admin admin) {
        if (nodesSpecification.minResources().nodes() > 1) {
            throw new IllegalArgumentException("You can only request a single log server");
        }
        Collection<Object> hosts = List.of();
        if (nodesSpecification.isDedicated()) {
            hosts = this.allocateHosts(admin.hostSystem(), "logserver", nodesSpecification);
        } else if (this.containerModels.iterator().hasNext()) {
            hosts = this.sortedContainerHostsFrom(this.containerModels.iterator().next(), nodesSpecification.minResources().nodes(), false);
        } else {
            this.context.getDeployLogger().logApplicationPackage(Level.INFO, "No container host available to use for running logserver");
        }
        if (hosts.isEmpty()) {
            return;
        }
        Logserver logserver = this.createLogserver(deployState, admin, hosts);
        if (nodesSpecification.isDedicated() || deployState.isHosted() && deployState.getProperties().applicationId().instance().isTester()) {
            this.createContainerOnLogserverHost(deployState, admin, logserver.getHostResource());
        }
    }

    private NodesSpecification createNodesSpecificationForLogserver() {
        DeployState deployState = this.context.getDeployState();
        if (deployState.getProperties().useDedicatedNodeForLogserver() && this.context.getApplicationType() == ConfigModelContext.ApplicationType.DEFAULT && deployState.isHosted() && !deployState.getProperties().applicationId().instance().isTester()) {
            return NodesSpecification.dedicated(1, this.context);
        }
        return NodesSpecification.nonDedicated(1, this.context);
    }

    private void createContainerOnLogserverHost(DeployState deployState, Admin admin, HostResource hostResource) {
        LogserverContainerCluster logServerCluster = new LogserverContainerCluster(admin, "logs", deployState);
        ContainerModel logserverClusterModel = new ContainerModel(this.context.withParent(admin).withId(logServerCluster.getSubId()));
        logserverClusterModel.setCluster(logServerCluster);
        LogserverContainer container = new LogserverContainer(logServerCluster, deployState);
        container.setHostResource(hostResource);
        container.initService(deployState);
        logServerCluster.addContainer(container);
        admin.addAndInitializeService(deployState, hostResource, container);
        admin.setLogserverContainerCluster(logServerCluster);
        this.context.getConfigModelRepoAdder().add(logserverClusterModel);
    }

    private Collection<HostResource> allocateHosts(HostSystem hostSystem, String clusterId, NodesSpecification nodesSpecification) {
        return nodesSpecification.provision(hostSystem, ClusterSpec.Type.admin, ClusterSpec.Id.from((String)clusterId), this.context.getDeployLogger(), false).keySet();
    }

    private List<HostResource> pickContainerHostsForSlobrok(int count, int minHostsPerContainerCluster) {
        int hostsPerCluster = (int)Math.max((double)minHostsPerContainerCluster, Math.ceil((double)count / (double)this.containerModels.size()));
        ArrayList<HostResource> picked = new ArrayList<HostResource>();
        for (ContainerModel containerModel : this.containerModels) {
            picked.addAll(this.pickContainerHostsFrom(containerModel, hostsPerCluster));
        }
        return picked;
    }

    private List<HostResource> pickContainerHostsFrom(ContainerModel model, int count) {
        boolean retired = true;
        List<HostResource> picked = this.sortedContainerHostsFrom(model, count, !retired);
        picked.addAll(this.sortedContainerHostsFrom(model, count, retired));
        return picked;
    }

    private List<HostResource> sortedContainerHostsFrom(ContainerModel model, int count, boolean retired) {
        List hosts = model.getCluster().getContainers().stream().filter(container -> retired == container.isRetired()).map(AbstractService::getHostResource).sorted(HostResource::comparePrimarilyByIndexTo).collect(Collectors.toCollection(ArrayList::new));
        return hosts.subList(0, Math.min(count, hosts.size()));
    }

    private Logserver createLogserver(DeployState deployState, Admin admin, Collection<HostResource> hosts) {
        Logserver logserver = new Logserver(admin);
        logserver.setHostResource(hosts.iterator().next());
        admin.setLogserver(logserver);
        logserver.initService(deployState);
        return logserver;
    }

    private void createSlobroks(DeployState deployState, Admin admin, Collection<HostResource> hosts) {
        if (hosts.isEmpty()) {
            return;
        }
        ArrayList<Slobrok> slobroks = new ArrayList<Slobrok>();
        int index = 0;
        for (HostResource host : hosts) {
            Slobrok slobrok = new Slobrok(admin, index++, deployState.featureFlags());
            slobrok.setHostResource(host);
            slobroks.add(slobrok);
            slobrok.initService(deployState);
        }
        admin.addSlobroks(slobroks);
    }
}

