/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingContext;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.PlatformBundles;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class ClusterControllerContainerCluster
extends ContainerCluster<ClusterControllerContainer> {
    private static final Set<Path> UNNECESSARY_BUNDLES = Collections.unmodifiableSet(PlatformBundles.VESPA_SECURITY_BUNDLES);
    private final ReindexingContext reindexingContext;

    public ClusterControllerContainerCluster(AbstractConfigProducer<?> parent, String subId, String name, DeployState deployState) {
        super(parent, subId, name, deployState, false);
        this.addDefaultHandlersWithVip();
        this.reindexingContext = ClusterControllerContainerCluster.createReindexingContext(deployState);
        this.setJvmGCOptions(deployState.getProperties().jvmGCOptions(Optional.of(ClusterSpec.Type.admin)));
    }

    @Override
    protected Set<Path> unnecessaryPlatformBundles() {
        return UNNECESSARY_BUNDLES;
    }

    @Override
    protected void doPrepare(DeployState deployState) {
    }

    @Override
    protected boolean messageBusEnabled() {
        return false;
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.heapsize(128);
    }

    public ReindexingContext reindexingContext() {
        return this.reindexingContext;
    }

    private static ReindexingContext createReindexingContext(DeployState deployState) {
        return new ReindexingContext(deployState.reindexing().orElse(Reindexing.DISABLED_INSTANCE));
    }
}

