/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.schema.RankingExpressionBody;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class LargeRankingExpressions {
    private final Map<String, RankingExpressionBody> expressions = new ConcurrentHashMap<String, RankingExpressionBody>();
    private final FileRegistry fileRegistry;
    private final int limit;

    public LargeRankingExpressions(FileRegistry fileRegistry) {
        this(fileRegistry, 8192);
    }

    public LargeRankingExpressions(FileRegistry fileRegistry, int limit) {
        this.fileRegistry = fileRegistry;
        this.limit = limit;
    }

    public void add(RankingExpressionBody expression) {
        String name = expression.getName();
        RankingExpressionBody prev = this.expressions.putIfAbsent(name, expression);
        if (prev == null) {
            expression.validate();
            expression.register(this.fileRegistry);
        } else if (!prev.getBlob().equals(expression.getBlob())) {
            throw new IllegalArgumentException("Ranking expression '" + name + "' defined twice. Previous blob with " + prev.getBlob().remaining() + " bytes, while current has " + expression.getBlob().remaining() + " bytes");
        }
    }

    public int limit() {
        return this.limit;
    }

    public Collection<RankingExpressionBody> expressions() {
        return this.expressions.values().stream().sorted().collect(Collectors.toUnmodifiableList());
    }

    public Map<String, RankingExpressionBody> asMap() {
        return Collections.unmodifiableMap(this.expressions);
    }
}

