/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.utils.internal.ReflectionUtil;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConfigValueChangeValidator
implements ChangeValidator {
    private final DeployLogger logger;

    public ConfigValueChangeValidator(DeployLogger logger) {
        this.logger = logger;
    }

    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, ValidationOverrides overrides, Instant now) {
        return this.findConfigChangesFromModels(currentModel, nextModel).collect(Collectors.toList());
    }

    public Stream<ConfigChangeAction> findConfigChangesFromModels(AbstractConfigProducerRoot currentModel, AbstractConfigProducerRoot nextModel) {
        return nextModel.getDescendantServices().stream().map(service -> this.findConfigChangeActionForService((Service)service, currentModel, nextModel)).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<ConfigChangeAction> findConfigChangeActionForService(Service service, AbstractConfigProducerRoot currentModel, AbstractConfigProducerRoot nextModel) {
        List changes = this.findConfigChangesForService(service, currentModel, nextModel).collect(Collectors.toList());
        if (changes.isEmpty()) {
            return Optional.empty();
        }
        String description = ConfigValueChangeValidator.createDescriptionOfConfigChanges(changes.stream());
        ClusterSpec.Id id = service.getHost().spec().membership().isPresent() ? ((ClusterMembership)service.getHost().spec().membership().get()).cluster().id() : ClusterSpec.Id.from((String)service.getConfigId());
        return Optional.of(new VespaRestartAction(id, description, service.getServiceInfo()));
    }

    private Stream<ChangesRequiringRestart> findConfigChangesForService(Service service, AbstractConfigProducerRoot currentModel, AbstractConfigProducerRoot nextModel) {
        Class<?> serviceClass = service.getClass();
        if (!currentModel.getService(service.getConfigId()).isPresent()) {
            return Stream.empty();
        }
        return ConfigValueChangeValidator.getConfigInstancesFromServiceAnnotations(serviceClass).map(configClass -> this.compareConfigFromCurrentAndNextModel(service, (Class<? extends ConfigInstance>)configClass, currentModel, nextModel)).filter(Optional::isPresent).map(Optional::get).filter(ChangesRequiringRestart::needsRestart);
    }

    private static String createDescriptionOfConfigChanges(Stream<ChangesRequiringRestart> changesStream) {
        return changesStream.map(changes -> changes.toString("")).collect(Collectors.joining("\n"));
    }

    private static Stream<Class<? extends ConfigInstance>> getConfigInstancesFromServiceAnnotations(Class<? extends Service> serviceClass) {
        List<Class<?>> classHierarchy = ReflectionUtil.getAllSuperclasses(serviceClass);
        classHierarchy.add(serviceClass);
        return classHierarchy.stream().filter(Service.class::isAssignableFrom).filter(clazz -> clazz.isAnnotationPresent(RestartConfigs.class)).map(clazz -> {
            RestartConfigs annotation = clazz.getDeclaredAnnotation(RestartConfigs.class);
            if (annotation.value().length == 0) {
                throw new IllegalStateException(String.format("%s has a %s annotation with no ConfigInstances given as argument.", clazz.getSimpleName(), RestartConfigs.class.getSimpleName()));
            }
            return annotation;
        }).map(RestartConfigs::value).flatMap(Arrays::stream).distinct();
    }

    private Optional<ChangesRequiringRestart> compareConfigFromCurrentAndNextModel(Service service, Class<? extends ConfigInstance> configClass, AbstractConfigProducerRoot currentModel, AbstractConfigProducerRoot nextModel) {
        if (!ConfigValueChangeValidator.hasConfigFieldsFlaggedWithRestart(configClass, service.getClass())) {
            this.logger.logApplicationPackage(Level.FINE, String.format("%s is listed in the annotation for %s, but does not have any restart flags in its config definition.", configClass.getSimpleName(), service.getClass().getSimpleName()));
            return Optional.empty();
        }
        Optional<ConfigInstance> nextConfig = ConfigValueChangeValidator.getConfigFromModel(nextModel, configClass, service.getConfigId());
        if (!nextConfig.isPresent()) {
            this.logger.logApplicationPackage(Level.FINE, String.format("%s is listed as restart config for %s, but the config does not exist in the new model.", configClass.getSimpleName(), service.getClass().getSimpleName()));
            return Optional.empty();
        }
        Optional<ConfigInstance> currentConfig = ConfigValueChangeValidator.getConfigFromModel(currentModel, configClass, service.getConfigId());
        if (!currentConfig.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(ReflectionUtil.getChangesRequiringRestart(currentConfig.get(), nextConfig.get()));
    }

    private static boolean hasConfigFieldsFlaggedWithRestart(Class<? extends ConfigInstance> configClass, Class<? extends Service> serviceClass) {
        if (!ReflectionUtil.hasRestartMethods(configClass)) {
            throw new IllegalStateException(String.format("%s is listed as restart config for %s but does not contain any restart inspection methods.", configClass.getSimpleName(), serviceClass.getSimpleName()));
        }
        return ReflectionUtil.containsFieldsFlaggedWithRestart(configClass);
    }

    private static Optional<ConfigInstance> getConfigFromModel(AbstractConfigProducerRoot configModel, Class<? extends ConfigInstance> configClass, String configKey) {
        try {
            return Optional.ofNullable(configModel.getConfig(configClass, configKey));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

