/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import java.time.Instant;
import java.util.List;

public class CloudAccountChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        for (ClusterSpec.Id clusterId : current.allClusters()) {
            CloudAccount currentAccount = CloudAccountChangeValidator.cloudAccountOf(current, clusterId);
            CloudAccount nextAccount = CloudAccountChangeValidator.cloudAccountOf(next, clusterId);
            if (currentAccount == null || nextAccount == null || nextAccount.equals((Object)currentAccount)) continue;
            throw new IllegalArgumentException("Cannot change cloud account from " + currentAccount + " to " + nextAccount + ". The existing deployment must be removed before changing accounts");
        }
        return List.of();
    }

    private static CloudAccount cloudAccountOf(VespaModel model, ClusterSpec.Id cluster) {
        Capacity capacity = (Capacity)model.provisioned().all().get(cluster);
        return capacity == null ? null : capacity.cloudAccount().orElse(CloudAccount.empty);
    }
}

