/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.google.common.base.Joiner;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.container.Container;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ClusterControllerCluster
extends AbstractConfigProducer<ClusterControllerContainerCluster>
implements ZookeeperServerConfig.Producer,
ZookeepersConfig.Producer {
    private static final int ZK_CLIENT_PORT = 2181;
    private ClusterControllerContainerCluster containerCluster = null;
    private final Set<String> previousHosts;

    public ClusterControllerCluster(AbstractConfigProducer<?> parent, String subId, DeployState deployState) {
        super(parent, subId);
        this.previousHosts = Collections.unmodifiableSet(deployState.getPreviousModel().stream().map(Model::allocatedHosts).map(AllocatedHosts::getHosts).flatMap(Collection::stream).map(HostSpec::hostname).collect(Collectors.toCollection(() -> new LinkedHashSet())));
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.clientPort(2181);
        builder.juteMaxBuffer(0x100000);
        builder.snapshotCount(1000);
        for (ClusterControllerContainer container : this.containerCluster.getContainers()) {
            ZookeeperServerConfig.Server.Builder serverBuilder = new ZookeeperServerConfig.Server.Builder();
            serverBuilder.hostname(container.getHostName());
            serverBuilder.id(container.index());
            serverBuilder.joining(!this.previousHosts.isEmpty() && !this.previousHosts.contains(container.getHostName()));
            serverBuilder.retired(container.isRetired());
            builder.server(serverBuilder);
        }
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        ArrayList<CallSite> controllerHosts = new ArrayList<CallSite>();
        for (Container container : this.containerCluster.getContainers()) {
            controllerHosts.add((CallSite)((Object)(container.getHostName() + ":2181")));
        }
        builder.zookeeperserverlist(Joiner.on((String)",").join(controllerHosts));
    }

    @Override
    protected void addChild(ClusterControllerContainerCluster cluster) {
        super.addChild(cluster);
        this.containerCluster = cluster;
    }

    @Override
    public void validate() {
        Objects.requireNonNull(this.containerCluster);
        for (Container c1 : this.containerCluster.getContainers()) {
            assert (c1 instanceof ClusterControllerContainer);
            for (Service service : c1.getHostResource().getServices()) {
                if (!(service instanceof Configserver)) continue;
                throw new IllegalArgumentException("Error validating cluster controller cluster: cluster controller '" + c1.getConfigId() + "' is set to run on the same host as a configserver");
            }
            for (Container c2 : this.containerCluster.getContainers()) {
                if (c1 == c2 || !c1.getHostName().equals(c2.getHostName())) continue;
                throw new IllegalArgumentException("Error validating cluster controller cluster: cluster controllers '" + c1.getConfigId() + "' and '" + c2.getConfigId() + "' share the same host");
            }
        }
    }
}

