/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.document.DataType;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.BooleanIndexDefinition;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.Dictionary;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.NormalizeLevel;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.Sorting;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.document.annotation.SDAnnotationType;
import com.yahoo.schema.parser.ConvertParsedTypes;
import com.yahoo.schema.parser.DictionaryOption;
import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedAttribute;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedIndex;
import com.yahoo.schema.parser.ParsedIndexingOp;
import com.yahoo.schema.parser.ParsedMatchSettings;
import com.yahoo.schema.parser.ParsedSorting;
import com.yahoo.schema.parser.ParsedStruct;
import com.yahoo.schema.parser.ParsedSummaryField;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class ConvertParsedFields {
    private final ConvertParsedTypes.TypeResolver context;
    private final Map<String, SDDocumentType> structProxies;

    ConvertParsedFields(ConvertParsedTypes.TypeResolver context, Map<String, SDDocumentType> structProxies) {
        this.context = context;
        this.structProxies = structProxies;
    }

    static void convertMatchSettings(SDField field, ParsedMatchSettings parsed) {
        parsed.getMatchType().ifPresent(matchingType -> field.setMatchingType((MatchType)((Object)matchingType)));
        parsed.getMatchCase().ifPresent(casing -> field.setMatchingCase((Case)((Object)casing)));
        parsed.getGramSize().ifPresent(gramSize -> field.getMatching().setGramSize((int)gramSize));
        parsed.getMaxLength().ifPresent(maxLength -> field.getMatching().maxLength((int)maxLength));
        parsed.getMatchAlgorithm().ifPresent(matchingAlgorithm -> field.setMatchingAlgorithm((MatchAlgorithm)((Object)matchingAlgorithm)));
        parsed.getExactTerminator().ifPresent(exactMatchTerminator -> field.getMatching().setExactMatchTerminator((String)exactMatchTerminator));
    }

    void convertSorting(SDField field, ParsedSorting parsed, String name) {
        Attribute attribute = field.getAttributes().get(name);
        if (attribute == null) {
            attribute = new Attribute(name, field.getDataType());
            field.addAttribute(attribute);
        }
        Sorting sorting = attribute.getSorting();
        if (parsed.getAscending()) {
            sorting.setAscending();
        } else {
            sorting.setDescending();
        }
        parsed.getFunction().ifPresent(function -> sorting.setFunction((Sorting.Function)((Object)function)));
        parsed.getStrength().ifPresent(strength -> sorting.setStrength((Sorting.Strength)((Object)strength)));
        parsed.getLocale().ifPresent(locale -> sorting.setLocale((String)locale));
    }

    void convertAttribute(SDField field, ParsedAttribute parsed) {
        Optional<ParsedSorting> sorting;
        String name = parsed.name();
        String fieldName = field.getName();
        Attribute attribute = null;
        if (fieldName.endsWith("." + name)) {
            attribute = field.getAttributes().get(field.getName());
        }
        if (attribute == null && (attribute = field.getAttributes().get(name)) == null) {
            attribute = new Attribute(name, field.getDataType());
            field.addAttribute(attribute);
        }
        attribute.setPaged(parsed.getPaged());
        attribute.setFastSearch(parsed.getFastSearch());
        if (parsed.getFastRank()) {
            attribute.setFastRank(parsed.getFastRank());
        }
        attribute.setFastAccess(parsed.getFastAccess());
        attribute.setMutable(parsed.getMutable());
        attribute.setEnableOnlyBitVector(parsed.getEnableOnlyBitVector());
        for (String alias : parsed.getAliases()) {
            field.getAliasToName().put(alias, parsed.lookupAliasedFrom(alias));
        }
        Optional<String> distanceMetric = parsed.getDistanceMetric();
        if (distanceMetric.isPresent()) {
            String upper = distanceMetric.get().toUpperCase(Locale.ENGLISH);
            attribute.setDistanceMetric(Attribute.DistanceMetric.valueOf(upper));
        }
        if ((sorting = parsed.getSorting()).isPresent()) {
            this.convertSorting(field, sorting.get(), name);
        }
    }

    private void convertRankType(SDField field, String indexName, String rankType) {
        RankType type = RankType.fromString(rankType);
        if (indexName == null || indexName.equals("")) {
            field.setRankType(type);
        } else {
            Index index = field.getIndex(indexName);
            if (index == null) {
                index = new Index(indexName);
                field.addIndex(index);
            }
            index.setRankType(type);
        }
    }

    private void convertNormalizing(SDField field, String setting) {
        NormalizeLevel.Level level;
        if ("none".equals(setting)) {
            level = NormalizeLevel.Level.NONE;
        } else if ("codepoint".equals(setting)) {
            level = NormalizeLevel.Level.CODEPOINT;
        } else if ("lowercase".equals(setting)) {
            level = NormalizeLevel.Level.LOWERCASE;
        } else if ("accent".equals(setting)) {
            level = NormalizeLevel.Level.ACCENT;
        } else if ("all".equals(setting)) {
            level = NormalizeLevel.Level.ACCENT;
        } else {
            throw new IllegalArgumentException("invalid normalizing setting: " + setting);
        }
        field.setNormalizing(new NormalizeLevel(level, true));
    }

    private void convertCommonFieldSettings(SDField field, ParsedField parsed) {
        ConvertParsedFields.convertMatchSettings(field, parsed.matchSettings());
        Optional<ParsedIndexingOp> indexing = parsed.getIndexing();
        if (indexing.isPresent()) {
            field.setIndexingScript(indexing.get().script());
        }
        parsed.getWeight().ifPresent(value -> field.setWeight((int)value));
        parsed.getStemming().ifPresent(value -> field.setStemming((Stemming)((Object)value)));
        parsed.getNormalizing().ifPresent(value -> this.convertNormalizing(field, (String)value));
        for (ParsedAttribute attribute : parsed.getAttributes()) {
            this.convertAttribute(field, attribute);
        }
        for (ParsedSummaryField summaryField : parsed.getSummaryFields()) {
            DataType dataType = field.getDataType();
            ParsedType otherType = summaryField.getType();
            if (otherType != null) {
                dataType = this.context.resolveType(otherType);
            }
            this.convertSummaryField(field, summaryField, dataType);
        }
        for (String command : parsed.getQueryCommands()) {
            field.addQueryCommand(command);
        }
        for (ParsedField structField : parsed.getStructFields()) {
            this.convertStructField(field, structField);
        }
        if (parsed.hasLiteral()) {
            field.getRanking().setLiteral(true);
        }
        if (parsed.hasFilter()) {
            field.getRanking().setFilter(true);
        }
        if (parsed.hasNormal()) {
            field.getRanking().setNormal(true);
        }
    }

    private void convertStructField(SDField field, ParsedField parsed) {
        SDField structField = field.getStructField(parsed.name());
        if (structField == null) {
            throw new IllegalArgumentException("Struct field '" + parsed.name() + "' has not been defined in struct for field '" + field.getName() + "'.");
        }
        this.convertCommonFieldSettings(structField, parsed);
    }

    private void convertExtraFieldSettings(SDField field, ParsedField parsed) {
        String name = parsed.name();
        for (DictionaryOption dictOp : parsed.getDictionaryOptions()) {
            Dictionary dictionary = field.getOrSetDictionary();
            switch (dictOp) {
                case HASH: {
                    dictionary.updateType(Dictionary.Type.HASH);
                    break;
                }
                case BTREE: {
                    dictionary.updateType(Dictionary.Type.BTREE);
                    break;
                }
                case CASED: {
                    dictionary.updateMatch(Case.CASED);
                    break;
                }
                case UNCASED: {
                    dictionary.updateMatch(Case.UNCASED);
                }
            }
        }
        for (ParsedIndex index : parsed.getIndexes()) {
            this.convertIndex(field, index);
        }
        for (String alias : parsed.getAliases()) {
            field.getAliasToName().put(alias, parsed.lookupAliasedFrom(alias));
        }
        parsed.getRankTypes().forEach((indexName, rankType) -> this.convertRankType(field, (String)indexName, (String)rankType));
        parsed.getSorting().ifPresent(sortInfo -> this.convertSorting(field, (ParsedSorting)sortInfo, name));
        if (parsed.hasBolding()) {
            SummaryField summaryField = field.getSummaryField(name, true);
            summaryField.addSource(name);
            summaryField.addDestination("default");
            summaryField.setTransform(summaryField.getTransform().bold());
        }
    }

    static void convertSummaryFieldSettings(SummaryField summary, ParsedSummaryField parsed) {
        SummaryTransform transform = SummaryTransform.NONE;
        if (parsed.getMatchedElementsOnly()) {
            transform = SummaryTransform.MATCHED_ELEMENTS_FILTER;
        } else if (parsed.getDynamic()) {
            transform = SummaryTransform.DYNAMICTEASER;
        }
        if (parsed.getBolded()) {
            transform = transform.bold();
        }
        summary.setTransform(transform);
        for (String source : parsed.getSources()) {
            summary.addSource(source);
        }
        for (String destination : parsed.getDestinations()) {
            summary.addDestination(destination);
        }
        summary.setImplicit(false);
    }

    private void convertSummaryField(SDField field, ParsedSummaryField parsed, DataType type) {
        SummaryField summary = new SummaryField(parsed.name(), type);
        ConvertParsedFields.convertSummaryFieldSettings(summary, parsed);
        summary.addDestination("default");
        if (parsed.getSources().isEmpty()) {
            summary.addSource(field.getName());
        }
        field.addSummaryField(summary);
    }

    private void convertIndex(SDField field, ParsedIndex parsed) {
        String indexName = parsed.name();
        Index index = field.getIndex(indexName);
        if (index == null) {
            index = new Index(indexName);
            field.addIndex(index);
        }
        this.convertIndexSettings(index, parsed);
    }

    private void convertIndexSettings(Index index, ParsedIndex parsed) {
        parsed.getPrefix().ifPresent(prefix -> index.setPrefix((boolean)prefix));
        for (String alias : parsed.getAliases()) {
            index.addAlias(alias);
        }
        parsed.getStemming().ifPresent(stemming -> index.setStemming((Stemming)((Object)stemming)));
        Optional<Integer> arity = parsed.getArity();
        Optional<Long> lowerBound = parsed.getLowerBound();
        Optional<Long> upperBound = parsed.getUpperBound();
        Optional<Double> densePostingListThreshold = parsed.getDensePostingListThreshold();
        if (arity.isPresent() || lowerBound.isPresent() || upperBound.isPresent() || densePostingListThreshold.isPresent()) {
            BooleanIndexDefinition bid = new BooleanIndexDefinition(arity, lowerBound, upperBound, densePostingListThreshold);
            index.setBooleanIndexDefiniton(bid);
        }
        parsed.getEnableBm25().ifPresent(enableBm25 -> index.setInterleavedFeatures((boolean)enableBm25));
        parsed.getHnswIndexParams().ifPresent(hnswIndexParams -> index.setHnswIndexParams((HnswIndexParams)hnswIndexParams));
    }

    SDField convertDocumentField(Schema schema, SDDocumentType document, ParsedField parsed) {
        String name = parsed.name();
        DataType dataType = this.context.resolveType(parsed.getType());
        SDField field = new SDField(document, name, dataType);
        this.convertCommonFieldSettings(field, parsed);
        this.convertExtraFieldSettings(field, parsed);
        document.addField(field);
        return field;
    }

    void convertExtraField(Schema schema, ParsedField parsed) {
        String name = parsed.name();
        DataType dataType = this.context.resolveType(parsed.getType());
        SDField field = new SDField(schema.getDocument(), name, dataType);
        this.convertCommonFieldSettings(field, parsed);
        this.convertExtraFieldSettings(field, parsed);
        schema.addExtraField(field);
    }

    void convertExtraIndex(Schema schema, ParsedIndex parsed) {
        Index index = new Index(parsed.name());
        this.convertIndexSettings(index, parsed);
        schema.addIndex(index);
    }

    SDDocumentType convertStructDeclaration(Schema schema, SDDocumentType document, ParsedStruct parsed) {
        SDDocumentType structProxy = new SDDocumentType(parsed.name(), schema);
        for (ParsedField parsedField : parsed.getFields()) {
            DataType fieldType = this.context.resolveType(parsedField.getType());
            SDField field = new SDField(document, parsedField.name(), fieldType);
            this.convertCommonFieldSettings(field, parsedField);
            structProxy.addField(field);
            if (!parsedField.hasIdOverride()) continue;
            structProxy.setFieldId(field, parsedField.idOverride());
        }
        for (ParsedStruct inherit : parsed.getResolvedInherits()) {
            structProxy.inherit(this.structProxies.get(inherit.getFullName()));
        }
        structProxy.setStruct(this.context.resolveStruct(parsed));
        this.structProxies.put(parsed.getFullName(), structProxy);
        return structProxy;
    }

    void convertAnnotation(Schema schema, SDDocumentType document, ParsedAnnotation parsed) {
        SDAnnotationType annType = this.context.resolveAnnotation(parsed.name());
        Optional<ParsedStruct> withStruct = parsed.getStruct();
        if (withStruct.isPresent()) {
            ParsedStruct parsedStruct = withStruct.get();
            SDDocumentType structProxy = this.convertStructDeclaration(schema, document, parsedStruct);
            structProxy.setStruct(this.context.resolveStruct(parsedStruct));
            annType.setSdDocType(structProxy);
        }
        document.addAnnotation(annType);
    }
}

