/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.service.VespaServicesConfig;
import com.yahoo.vespa.model.Service;
import java.util.List;
import java.util.stream.Collectors;

public class VespaServicesConfigGenerator {
    public static List<VespaServicesConfig.Service.Builder> generate(List<Service> services) {
        return services.stream().filter(VespaServicesConfigGenerator::doIncludeServiceMetrics).map(VespaServicesConfigGenerator::toServiceBuilder).collect(Collectors.toList());
    }

    private static boolean doIncludeServiceMetrics(Service s) {
        return s.getStartupCommand().isPresent() || s.getServiceType().equals("configserver") || s.getServiceType().equals("config-sentinel");
    }

    private static VespaServicesConfig.Service.Builder toServiceBuilder(Service service) {
        VespaServicesConfig.Service.Builder builder = new VespaServicesConfig.Service.Builder().configId(service.getConfigId()).name(service.getServiceName()).port(service.getHealthPort());
        service.getDefaultMetricDimensions().forEach((name, value) -> builder.dimension(VespaServicesConfigGenerator.toServiceDimensionBuilder(name, value)));
        return builder;
    }

    private static VespaServicesConfig.Service.Dimension.Builder toServiceDimensionBuilder(String name, String value) {
        return new VespaServicesConfig.Service.Dimension.Builder().key(name).value(value);
    }
}

