/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AttributesImplicitWord
extends Processor {
    public AttributesImplicitWord(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (ImmutableSDField immutableSDField : this.schema.allConcreteFields()) {
            this.processFieldRecursive(immutableSDField);
        }
    }

    private void processFieldRecursive(ImmutableSDField field) {
        this.processField(field);
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            this.processFieldRecursive(immutableSDField);
        }
    }

    private void processField(ImmutableSDField field) {
        if (this.fieldImplicitlyWordMatch(field)) {
            field.getMatching().setType(MatchType.WORD);
        }
    }

    private boolean fieldImplicitlyWordMatch(ImmutableSDField field) {
        PrimitiveDataType dt = field.getDataType().getPrimitiveType();
        if (dt != null && dt instanceof NumericDataType) {
            return false;
        }
        return !field.hasIndex() && !field.getAttributes().isEmpty() && field.getIndices().isEmpty() && !field.getMatching().isTypeUserSet();
    }
}

