/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.expressiontransforms.OnnxModelTransformer;
import com.yahoo.schema.processing.Processor;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.ml.OnnxModelInfo;
import java.util.Map;

public class OnnxModelConfigGenerator
extends Processor {
    public OnnxModelConfigGenerator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            if (profile.getFirstPhaseRanking() != null) {
                this.process(profile.getFirstPhaseRanking().getRoot(), profile);
            }
            if (profile.getSecondPhaseRanking() != null) {
                this.process(profile.getSecondPhaseRanking().getRoot(), profile);
            }
            for (Map.Entry<String, RankProfile.RankingExpressionFunction> function : profile.getFunctions().entrySet()) {
                this.process(function.getValue().function().getBody().getRoot(), profile);
            }
            for (ReferenceNode feature : profile.getSummaryFeatures()) {
                this.process(feature, profile);
            }
        }
    }

    private void process(ExpressionNode node, RankProfile profile) {
        if (node instanceof ReferenceNode) {
            this.process((ReferenceNode)node, profile);
        } else if (node instanceof CompositeNode) {
            for (ExpressionNode child : ((CompositeNode)node).children()) {
                this.process(child, profile);
            }
        }
    }

    private void process(ReferenceNode feature, RankProfile profile) {
        if ((feature.getName().equals("onnxModel") || feature.getName().equals("onnx")) && feature.getArguments().size() > 0 && feature.getArguments().expressions().get(0) instanceof ConstantNode) {
            ConstantNode node = (ConstantNode)feature.getArguments().expressions().get(0);
            String path = OnnxModelTransformer.stripQuotes(node.toString());
            String modelConfigName = OnnxModelTransformer.asValidIdentifier(path);
            if (!OnnxModelInfo.modelExists(path, this.schema.applicationPackage()) && !OnnxModelInfo.modelExists(path = ApplicationPackage.MODELS_DIR.append(path).toString(), this.schema.applicationPackage())) {
                return;
            }
            OnnxModel onnxModel = profile.onnxModels().get(modelConfigName);
            if (onnxModel == null) {
                profile.add(new OnnxModel(modelConfigName, path));
            }
        }
    }
}

