/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MapConfigModelRegistry
extends ConfigModelRegistry {
    private final List<ConfigModelBuilder> builders;

    @Inject
    public MapConfigModelRegistry(ComponentRegistry<? extends ConfigModelBuilder> registry) {
        this(registry.allComponents());
    }

    public MapConfigModelRegistry(Collection<? extends ConfigModelBuilder> builderCollection) {
        this.builders = new ArrayList<ConfigModelBuilder>(builderCollection);
    }

    @Override
    public Collection<ConfigModelBuilder> resolve(ConfigModelId id) {
        HashSet<ConfigModelBuilder> matchingBuilders = new HashSet<ConfigModelBuilder>(this.chained().resolve(id));
        for (ConfigModelBuilder builder : this.builders) {
            if (!builder.handlesElements().contains(id)) continue;
            matchingBuilders.add(builder);
        }
        return matchingBuilders;
    }

    @SafeVarargs
    public static ConfigModelRegistry createFromList(ConfigModelBuilder<? extends ConfigModel> ... builders) {
        return new MapConfigModelRegistry(Arrays.asList(builders));
    }
}

