/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.Affinity;
import com.yahoo.vespa.model.Client;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.builder.UserConfigBuilder;
import com.yahoo.vespa.model.builder.VespaModelBuilder;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VespaDomBuilder
extends VespaModelBuilder {
    public static final String JVM_OPTIONS = "jvm-options";
    public static final String OPTIONS = "options";
    public static final String JVM_GC_OPTIONS = "jvm-gc-options";
    public static final String GC_OPTIONS = "gc-options";
    public static final String PRELOAD_ATTRIB_NAME = "preload";
    public static final String MMAP_NOCORE_LIMIT = "mmap-core-limit";
    public static final String CORE_ON_OOM = "core-on-oom";
    public static final String NO_VESPAMALLOC = "no-vespamalloc";
    public static final String VESPAMALLOC = "vespamalloc";
    public static final String VESPAMALLOC_DEBUG = "vespamalloc-debug";
    public static final String VESPAMALLOC_DEBUG_STACKTRACE = "vespamalloc-debug-stacktrace";
    private static final String CPU_SOCKET_ATTRIB_NAME = "cpu-socket";
    public static final String CPU_SOCKET_AFFINITY_ATTRIB_NAME = "cpu-socket-affinity";
    public static final String Allocated_MEMORY_ATTRIB_NAME = "allocated-memory";
    public static final Logger log = Logger.getLogger(VespaDomBuilder.class.getPackage().toString());

    public static List<String> getHostAliases(NodeList hostAliases) {
        LinkedList<String> aliases = new LinkedList<String>();
        for (int i = 0; i < hostAliases.getLength(); ++i) {
            Node n = hostAliases.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (!e.getNodeName().equals("alias")) {
                throw new IllegalArgumentException("Unexpected tag: '" + e.getNodeName() + "' at node " + XML.getNodePath((Node)e, (String)" > ") + ", expected 'alias'.");
            }
            String alias = e.getFirstChild().getNodeValue();
            if (alias == null || alias.equals("")) {
                throw new IllegalArgumentException("Missing value for the alias tag at node " + XML.getNodePath((Node)e, (String)" > ") + "'.");
            }
            aliases.add(alias);
        }
        return aliases;
    }

    @Override
    public ApplicationConfigProducerRoot getRoot(String name, DeployState deployState, AbstractConfigProducer parent) {
        try {
            return (ApplicationConfigProducerRoot)new DomRootBuilder(name).build(deployState, parent, XmlHelper.getDocument(deployState.getApplicationPackage().getServices(), "services.xml").getDocumentElement());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getXmlWantedPort(Element spec) {
        return VespaDomBuilder.getXmlIntegerAttribute(spec, "baseport");
    }

    private static int getXmlIntegerAttribute(Element spec, String attributeName) {
        String value;
        String string = value = spec == null ? null : spec.getAttribute(attributeName);
        if (value == null || value.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal format for attribute '" + attributeName + "' at node " + XML.getNodePath((Node)spec, (String)" > ") + ", must be an integer", e);
        }
    }

    @Override
    public void postProc(DeployLogger deployLogger, AbstractConfigProducer root, ConfigModelRepo configModelRepo) {
        this.setContentSearchClusterIndexes(configModelRepo);
        this.createDocprocMBusServersAndClients(configModelRepo);
    }

    private void createDocprocMBusServersAndClients(ConfigModelRepo pc) {
        for (ContainerCluster<?> cluster : ContainerModel.containerClusters(pc)) {
            this.addServerAndClientsForChains(cluster.getDocproc());
        }
    }

    private void addServerAndClientsForChains(ContainerDocproc docproc) {
        if (docproc != null) {
            ((DocprocChains)docproc.getChains()).addServersAndClientsForChains();
        }
    }

    private void setContentSearchClusterIndexes(ConfigModelRepo configModelRepo) {
        int index = 0;
        for (SearchCluster sc : Content.getSearchClusters(configModelRepo)) {
            sc.setClusterIndex(index++);
        }
    }

    public static class DomRootBuilder
    extends DomConfigProducerBuilder<ApplicationConfigProducerRoot> {
        private final String name;

        DomRootBuilder(String name) {
            this.name = name;
        }

        @Override
        protected ApplicationConfigProducerRoot doBuild(DeployState deployState, AbstractConfigProducer<?> parent, Element producerSpec) {
            ApplicationConfigProducerRoot root = new ApplicationConfigProducerRoot(parent, this.name, deployState.getDocumentModel(), deployState.getVespaVersion(), deployState.getProperties().applicationId());
            root.setHostSystem(new HostSystem(root, "hosts", deployState.getProvisioner(), deployState.getDeployLogger()));
            new Client(root);
            return root;
        }
    }

    static class DomSimpleConfigProducerBuilder
    extends DomConfigProducerBuilder<SimpleConfigProducer<?>> {
        private final String configId;

        DomSimpleConfigProducerBuilder(String configId) {
            this.configId = configId;
        }

        @Override
        protected SimpleConfigProducer<?> doBuild(DeployState deployState, AbstractConfigProducer<?> parent, Element producerSpec) {
            return new SimpleConfigProducer(parent, this.configId);
        }
    }

    public static abstract class DomConfigProducerBuilder<T extends AbstractConfigProducer<?>> {
        public final T build(DeployState deployState, AbstractConfigProducer<?> ancestor, Element producerSpec) {
            T t = this.doBuild(deployState, ancestor, producerSpec);
            if (t instanceof AbstractService) {
                this.initializeService((AbstractService)t, deployState, ancestor.hostSystem(), producerSpec);
            } else {
                this.initializeProducer((AbstractConfigProducer<?>)t, deployState, producerSpec);
            }
            return t;
        }

        protected abstract T doBuild(DeployState var1, AbstractConfigProducer<?> var2, Element var3);

        private void initializeProducer(AbstractConfigProducer<?> child, DeployState deployState, Element producerSpec) {
            UserConfigRepo userConfigs = UserConfigBuilder.build(producerSpec, deployState, deployState.getDeployLogger());
            log.log(Level.FINE, () -> "Adding user configs " + userConfigs + " for " + producerSpec);
            child.mergeUserConfigs(userConfigs);
        }

        private void initializeService(AbstractService t, DeployState deployState, HostSystem hostSystem, Element producerSpec) {
            this.initializeProducer(t, deployState, producerSpec);
            if (producerSpec != null) {
                int port;
                if (producerSpec.hasAttribute(VespaDomBuilder.JVM_OPTIONS)) {
                    t.appendJvmOptions(producerSpec.getAttribute(VespaDomBuilder.JVM_OPTIONS));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.PRELOAD_ATTRIB_NAME)) {
                    t.setPreLoad(producerSpec.getAttribute(VespaDomBuilder.PRELOAD_ATTRIB_NAME));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.MMAP_NOCORE_LIMIT)) {
                    t.setMMapNoCoreLimit(Long.parseLong(producerSpec.getAttribute(VespaDomBuilder.MMAP_NOCORE_LIMIT)));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.CORE_ON_OOM)) {
                    t.setCoreOnOOM(Boolean.parseBoolean(producerSpec.getAttribute(VespaDomBuilder.CORE_ON_OOM)));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.NO_VESPAMALLOC)) {
                    t.setNoVespaMalloc(producerSpec.getAttribute(VespaDomBuilder.NO_VESPAMALLOC));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.VESPAMALLOC)) {
                    t.setVespaMalloc(producerSpec.getAttribute(VespaDomBuilder.VESPAMALLOC));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.VESPAMALLOC_DEBUG)) {
                    t.setVespaMallocDebug(producerSpec.getAttribute(VespaDomBuilder.VESPAMALLOC_DEBUG));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.VESPAMALLOC_DEBUG_STACKTRACE)) {
                    t.setVespaMallocDebugStackTrace(producerSpec.getAttribute(VespaDomBuilder.VESPAMALLOC_DEBUG_STACKTRACE));
                }
                if (producerSpec.hasAttribute(VespaDomBuilder.CPU_SOCKET_ATTRIB_NAME)) {
                    t.setAffinity(new Affinity.Builder().cpuSocket(Integer.parseInt(producerSpec.getAttribute(VespaDomBuilder.CPU_SOCKET_ATTRIB_NAME))).build());
                }
                if ((port = VespaDomBuilder.getXmlWantedPort(producerSpec)) > 0) {
                    t.setBasePort(port);
                }
                this.allocateHost(t, hostSystem, producerSpec);
            }
            if (!t.isInitialized()) {
                t.initService(deployState);
            }
        }

        private void allocateHost(AbstractService service, HostSystem hostSystem, Element producerSpec) {
            service.setHostResource(hostSystem.getHost(producerSpec.getAttribute("hostalias")));
        }
    }
}

